/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoverySender
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(UDPDiscoverySender.class);
    private MulticastSocket localSocket;
    private InetAddress multicastAddress;
    private final int multicastPort;
    private final StandardSerializer serializer = new StandardSerializer();

    public UDPDiscoverySender(String host, int port) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Constructing socket for sender on port [" + port + "]");
            }
            this.localSocket = new MulticastSocket(port);
            this.multicastAddress = InetAddress.getByName(host);
        }
        catch (IOException e) {
            log.error("Could not bind to multicast address [" + host + "]", e);
            throw e;
        }
        this.multicastPort = port;
    }

    @Override
    public void close() {
        try {
            if (this.localSocket != null && !this.localSocket.isClosed()) {
                this.localSocket.close();
            }
        }
        catch (Exception e) {
            log.error("Problem closing sender", e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void send(UDPDiscoveryMessage message) throws IOException {
        if (this.localSocket == null) {
            throw new IOException("Socket is null, cannot send message.");
        }
        if (this.localSocket.isClosed()) {
            throw new IOException("Socket is closed, cannot send message.");
        }
        if (log.isDebugEnabled()) {
            log.debug("sending UDPDiscoveryMessage, address [" + this.multicastAddress + "], port [" + this.multicastPort + "], message = " + message);
        }
        try {
            byte[] bytes = this.serializer.serialize(message);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.multicastAddress, this.multicastPort);
            if (log.isDebugEnabled()) {
                log.debug("Sending DatagramPacket. bytes.length [" + bytes.length + "] to " + this.multicastAddress + ":" + this.multicastPort);
            }
            this.localSocket.send(packet);
        }
        catch (IOException e) {
            log.error("Error sending message", e);
            throw e;
        }
    }

    public void requestBroadcast() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("sending requestBroadcast ");
        }
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setRequesterId(CacheInfo.listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.REQUEST);
        this.send(message);
    }

    public void passiveBroadcast(String host, int port, ArrayList<String> cacheNames) throws IOException {
        this.passiveBroadcast(host, port, cacheNames, CacheInfo.listenerId);
    }

    protected void passiveBroadcast(String host, int port, ArrayList<String> cacheNames, long listenerId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("sending passiveBroadcast ");
        }
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.PASSIVE);
        this.send(message);
    }

    public void removeBroadcast(String host, int port, ArrayList<String> cacheNames) throws IOException {
        this.removeBroadcast(host, port, cacheNames, CacheInfo.listenerId);
    }

    protected void removeBroadcast(String host, int port, ArrayList<String> cacheNames, long listenerId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("sending removeBroadcast ");
        }
        UDPDiscoveryMessage message = new UDPDiscoveryMessage();
        message.setHost(host);
        message.setPort(port);
        message.setCacheNames(cacheNames);
        message.setRequesterId(listenerId);
        message.setMessageType(UDPDiscoveryMessage.BroadcastType.REMOVE);
        this.send(message);
    }
}

