/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs.engine.CacheAdaptor;
import org.apache.commons.jcs.engine.CacheEventQueueFactory;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralCacheNoWait<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogFactory.getLog(LateralCacheNoWait.class);
    private final LateralCache<K, V> cache;
    private ICacheEventQueue<K, V> eventQueue;
    private int getCount = 0;
    private int removeCount = 0;
    private int putCount = 0;

    public LateralCacheNoWait(LateralCache<K, V> cache) {
        this.cache = cache;
        if (log.isDebugEnabled()) {
            log.debug("Constructing LateralCacheNoWait, LateralCache = [" + cache + "]");
        }
        CacheEventQueueFactory<K, V> fact = new CacheEventQueueFactory<K, V>();
        this.eventQueue = fact.createCacheEventQueue(new CacheAdaptor<K, V>(cache), CacheInfo.listenerId, cache.getCacheName(), cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), cache.getAuxiliaryCacheAttributes().getEventQueueType());
        if (cache.getStatus() == CacheStatus.ERROR) {
            this.eventQueue.destroy();
        }
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        ++this.putCount;
        try {
            this.eventQueue.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        ++this.getCount;
        if (this.getStatus() != CacheStatus.ERROR) {
            try {
                return this.cache.get(key);
            }
            catch (UnmarshalException ue) {
                log.debug("Retrying the get owing to UnmarshalException...");
                try {
                    return this.cache.get(key);
                }
                catch (IOException ex) {
                    log.error("Failed in retrying the get for the second time.");
                    this.eventQueue.destroy();
                }
            }
            catch (IOException ex) {
                this.eventQueue.destroy();
            }
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            Map<Object, ICacheElement> elements = keys.stream().collect(Collectors.toMap(key -> key, key -> this.get(key))).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(entry -> entry.getKey(), entry -> (ICacheElement)entry.getValue()));
            return elements;
        }
        return new HashMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        ++this.getCount;
        if (this.getStatus() != CacheStatus.ERROR) {
            try {
                return this.cache.getMatching(pattern);
            }
            catch (UnmarshalException ue) {
                log.debug("Retrying the get owing to UnmarshalException.");
                try {
                    return this.cache.getMatching(pattern);
                }
                catch (IOException ex) {
                    log.error("Failed in retrying the get for the second time.");
                    this.eventQueue.destroy();
                }
            }
            catch (IOException ex) {
                this.eventQueue.destroy();
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        try {
            return this.cache.getKeySet();
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
            return Collections.emptySet();
        }
    }

    @Override
    public boolean remove(K key) {
        ++this.removeCount;
        try {
            this.eventQueue.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
        return false;
    }

    @Override
    public void removeAll() {
        try {
            this.eventQueue.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
    }

    @Override
    public void dispose() {
        try {
            this.eventQueue.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error(ex);
            this.eventQueue.destroy();
        }
    }

    @Override
    public int getSize() {
        return this.cache.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return this.cache.getCacheType();
    }

    @Override
    public CacheStatus getStatus() {
        return this.eventQueue.isWorking() ? this.cache.getStatus() : CacheStatus.ERROR;
    }

    @Override
    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(ICacheServiceNonLocal<K, V> lateral) {
        this.cache.fixCache(lateral);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.eventQueue.isWorking()) {
            this.eventQueue.destroy();
        }
        CacheEventQueueFactory<K, V> fact = new CacheEventQueueFactory<K, V>();
        this.eventQueue = fact.createCacheEventQueue(new CacheAdaptor<K, V>(this.cache), CacheInfo.listenerId, this.cache.getCacheName(), this.cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.cache.getAuxiliaryCacheAttributes().getEventQueueType());
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cache.getAuxiliaryCacheAttributes();
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Lateral Cache No Wait";
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait");
        ArrayList elems = new ArrayList();
        IStats eqStats = this.eventQueue.getStatistics();
        elems.addAll(eqStats.getStatElements());
        elems.add(new StatElement<Integer>("Get Count", this.getCount));
        elems.add(new StatElement<Integer>("Remove Count", this.removeCount));
        elems.add(new StatElement<Integer>("Put Count", this.putCount));
        elems.add(new StatElement<AuxiliaryCacheAttributes>("Attributes", this.cache.getAuxiliaryCacheAttributes()));
        stats.setStatElements(elems);
        return stats;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" LateralCacheNoWait ");
        buf.append(" Status = " + (Object)((Object)this.getStatus()));
        buf.append(" cache = [" + this.cache.toString() + "]");
        return buf.toString();
    }
}

