/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public final class BugReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte MAXIMUM_SUPPRESSED_EXCEPTIONS = 4;
    private static final Deque<Pair<Instant, Throwable>> SUPPRESSED_EXCEPTIONS = new ArrayDeque<Pair<Instant, Throwable>>(4);
    private boolean includeStatusReport = true;
    private boolean includeData = true;
    private boolean includeAllStackTraces;
    private final ReportedException exception;
    private final CopyOnWriteArrayList<BugReportListener> listeners = new CopyOnWriteArrayList();

    public BugReport(ReportedException e) {
        this.exception = e;
        this.includeAllStackTraces = e.mayHaveConcurrentSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSuppressedException(Throwable t) {
        Deque<Pair<Instant, Throwable>> deque = SUPPRESSED_EXCEPTIONS;
        synchronized (deque) {
            SUPPRESSED_EXCEPTIONS.add(new Pair<Instant, Throwable>(Instant.now(), t != null ? t : new NullPointerException()));
            while (SUPPRESSED_EXCEPTIONS.size() > 4) {
                SUPPRESSED_EXCEPTIONS.pop();
            }
        }
    }

    public boolean isIncludeStatusReport() {
        return this.includeStatusReport;
    }

    public void setIncludeStatusReport(boolean includeStatusReport) {
        this.includeStatusReport = includeStatusReport;
        this.fireChange();
    }

    public boolean isIncludeData() {
        return this.includeData;
    }

    public void setIncludeData(boolean includeData) {
        this.includeData = includeData;
        this.fireChange();
    }

    public boolean isIncludeAllStackTraces() {
        return this.includeAllStackTraces;
    }

    public void setIncludeAllStackTraces(boolean includeAllStackTraces) {
        this.includeAllStackTraces = includeAllStackTraces;
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReportText(String header) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        if (this.isIncludeStatusReport()) {
            try {
                out.println(header);
            }
            catch (RuntimeException e) {
                out.println("Could not generate status report: " + e.getMessage());
            }
        }
        if (this.isIncludeData()) {
            this.exception.printReportDataTo(out);
        }
        this.exception.printReportStackTo(out);
        if (this.isIncludeAllStackTraces()) {
            this.exception.printReportThreadsTo(out);
        }
        Deque<Pair<Instant, Throwable>> deque = SUPPRESSED_EXCEPTIONS;
        synchronized (deque) {
            if (!SUPPRESSED_EXCEPTIONS.isEmpty()) {
                out.println("=== ADDITIONAL EXCEPTIONS ===");
                while (SUPPRESSED_EXCEPTIONS.peek() != null) {
                    Pair<Instant, Throwable> currentException = SUPPRESSED_EXCEPTIONS.pop();
                    out.println("==== Exception at " + ((Instant)currentException.a).toEpochMilli() + " ====");
                    ((Throwable)currentException.b).printStackTrace(out);
                }
            }
        }
        return stringWriter.toString().replaceAll("\r", "");
    }

    public void addChangeListener(BugReportListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(BugReportListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChange() {
        this.listeners.forEach(l -> l.bugReportChanged(this));
    }

    public static ReportedException intercept(Throwable t) {
        ReportedException e = t instanceof ReportedException ? (ReportedException)t : new ReportedException(t);
        e.startSection(BugReport.getCallingMethod(2));
        return e;
    }

    public static String getCallingMethod(int offset) {
        StackTraceElement found = BugReport.getCallingMethod(offset + 1, BugReport.class.getName(), "getCallingMethod"::equals);
        if (found != null) {
            return found.getClassName().replaceFirst(".*\\.", "") + "#" + found.getMethodName();
        }
        return "?";
    }

    public static StackTraceElement getCallingMethod(int offset, String className, Predicate<String> methodName) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTrace.length - offset; ++i) {
            StackTraceElement element = stackTrace[i];
            if (!className.equals(element.getClassName()) || !methodName.test(element.getMethodName())) continue;
            return stackTrace[i + offset];
        }
        return null;
    }

    @FunctionalInterface
    public static interface BugReportListener {
        public void bugReportChanged(BugReport var1);
    }
}

