/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageResizeMode;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class HiDPISupport {
    private static final Class<? extends Image> baseMultiResolutionImageClass = HiDPISupport.initBaseMultiResolutionImageClass();
    private static final Constructor<? extends Image> baseMultiResolutionImageConstructor = HiDPISupport.initBaseMultiResolutionImageConstructor();
    private static final Method resolutionVariantsMethod = HiDPISupport.initResolutionVariantsMethod();
    private static final Method resolutionVariantMethod = HiDPISupport.initResolutionVariantMethod();

    private HiDPISupport() {
    }

    public static Image getMultiResolutionImage(Image base, ImageResource ir, ImageResizeMode resizeMode) {
        double uiScale = HiDPISupport.getHiDPIScale();
        if (uiScale != 1.0 && baseMultiResolutionImageConstructor != null) {
            ImageIcon zoomed;
            Image mrImg;
            if (resizeMode == ImageResizeMode.BOUNDED) {
                resizeMode = ImageResizeMode.AUTO;
            }
            if ((mrImg = HiDPISupport.getMultiResolutionImage(Arrays.asList(base, (zoomed = ir.getImageIconAlreadyScaled(new Dimension((int)Math.round((double)base.getWidth(null) * uiScale), (int)Math.round((double)base.getHeight(null) * uiScale)), false, true, resizeMode)).getImage()))) != null) {
                return mrImg;
            }
        }
        return base;
    }

    public static Image getMultiResolutionImage(List<Image> imgs) {
        CheckParameterUtil.ensureThat(!imgs.isEmpty(), "imgs is empty");
        if (baseMultiResolutionImageConstructor != null) {
            try {
                return baseMultiResolutionImageConstructor.newInstance(new Object[]{imgs.toArray(new Image[0])});
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                Logging.error("Unexpected error while instantiating object of class BaseMultiResolutionImage: " + String.valueOf(ex));
            }
        }
        return imgs.get(0);
    }

    public static Image getBaseImage(Image img) {
        if (baseMultiResolutionImageClass == null || resolutionVariantsMethod == null) {
            return img;
        }
        if (baseMultiResolutionImageClass.isInstance(img)) {
            try {
                List imgVars = (List)resolutionVariantsMethod.invoke((Object)img, new Object[0]);
                if (!imgVars.isEmpty()) {
                    return (Image)imgVars.get(0);
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Logging.error("Unexpected error while calling method: " + String.valueOf(ex));
            }
        }
        return img;
    }

    public static List<Image> getResolutionVariants(Image img) {
        if (baseMultiResolutionImageClass == null || resolutionVariantsMethod == null) {
            return Collections.singletonList(img);
        }
        if (baseMultiResolutionImageClass.isInstance(img)) {
            try {
                List imgVars = (List)resolutionVariantsMethod.invoke((Object)img, new Object[0]);
                if (!imgVars.isEmpty()) {
                    return imgVars;
                }
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Logging.error("Unexpected error while calling method: " + String.valueOf(ex));
            }
        }
        return Collections.singletonList(img);
    }

    public static Image getResolutionVariant(Image img, double destImageWidth, double destImageHeight) {
        if (baseMultiResolutionImageClass == null || resolutionVariantsMethod == null) {
            return img;
        }
        if (baseMultiResolutionImageClass.isInstance(img)) {
            try {
                return (Image)resolutionVariantMethod.invoke((Object)img, destImageWidth, destImageHeight);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Logging.error("Unexpected error while calling method: " + String.valueOf(ex));
            }
        }
        return img;
    }

    public static double getHiDPIScale() {
        if (GraphicsEnvironment.isHeadless()) {
            return 1.0;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform transform = gc.getDefaultTransform();
        if (!Utils.equalsEpsilon(transform.getScaleX(), transform.getScaleY())) {
            Logging.warn("Unexpected ui transform: " + String.valueOf(transform));
        }
        return transform.getScaleX();
    }

    public static Image processMRImage(Image img, UnaryOperator<Image> processor) {
        return HiDPISupport.processMRImages(Collections.singletonList(img), imgs -> (Image)processor.apply((Image)imgs.get(0)));
    }

    public static Image processMRImages(List<Image> imgs, Function<List<Image>, Image> processor) {
        CheckParameterUtil.ensureThat(!imgs.isEmpty(), "at least one element expected");
        if (baseMultiResolutionImageClass != null) {
            return processor.apply(imgs);
        }
        List allVars = imgs.stream().map(HiDPISupport::getResolutionVariants).collect(Collectors.toList());
        int maxVariants = allVars.stream().mapToInt(List::size).max().getAsInt();
        if (maxVariants == 1) {
            return processor.apply(imgs);
        }
        List<Image> imgsProcessed = IntStream.range(0, maxVariants).mapToObj(k -> (Image)processor.apply(allVars.stream().map(vars -> (Image)vars.get(k)).collect(Collectors.toList()))).collect(Collectors.toList());
        return HiDPISupport.getMultiResolutionImage(imgsProcessed);
    }

    private static Class<? extends Image> initBaseMultiResolutionImageClass() {
        try {
            return Class.forName("java.awt.image.BaseMultiResolutionImage");
        }
        catch (ClassNotFoundException ex) {
            Logging.trace(ex);
            return null;
        }
    }

    private static Constructor<? extends Image> initBaseMultiResolutionImageConstructor() {
        try {
            return baseMultiResolutionImageClass != null ? baseMultiResolutionImageClass.getConstructor(Image[].class) : null;
        }
        catch (NoSuchMethodException ex) {
            Logging.error("Cannot find expected constructor: " + String.valueOf(ex));
            return null;
        }
    }

    private static Method initResolutionVariantsMethod() {
        try {
            return baseMultiResolutionImageClass != null ? baseMultiResolutionImageClass.getMethod("getResolutionVariants", new Class[0]) : null;
        }
        catch (NoSuchMethodException ex) {
            Logging.error("Cannot find expected method: " + String.valueOf(ex));
            return null;
        }
    }

    private static Method initResolutionVariantMethod() {
        try {
            return baseMultiResolutionImageClass != null ? baseMultiResolutionImageClass.getMethod("getResolutionVariant", Double.TYPE, Double.TYPE) : null;
        }
        catch (NoSuchMethodException ex) {
            Logging.error("Cannot find expected method: " + String.valueOf(ex));
            return null;
        }
    }
}

