/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuth20Parameters;
import org.openstreetmap.josm.data.oauth.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class OAuthParameters {
    private static final Map<String, JsonObject> RFC8414_RESPONSES = new HashMap<String, JsonObject>(1);
    private static final String OSM_API_DEFAULT = "https://api.openstreetmap.org/api";
    private static final String OSM_API_DEV = "https://api06.dev.openstreetmap.org/api";
    private static final String OSM_API_MASTER = "https://master.apis.dev.openstreetmap.org/api";

    private OAuthParameters() {
    }

    public static IOAuthParameters createDefault() {
        return OAuthParameters.createDefault(Config.getUrls().getDefaultOsmApiUrl(), OAuthVersion.OAuth20);
    }

    public static IOAuthParameters createDefault(String apiUrl, OAuthVersion oAuthVersion) {
        if (!Utils.isValidUrl(apiUrl)) {
            apiUrl = null;
        }
        switch (oAuthVersion) {
            case OAuth20: 
            case OAuth21: {
                return OAuthParameters.getDefaultOAuth20Parameters(apiUrl);
            }
        }
        throw new IllegalArgumentException("Unknown OAuth version: " + (Object)((Object)oAuthVersion));
    }

    private static JsonObject getRFC8414Parameters(String apiUrl) {
        block21: {
            HttpClient client = null;
            try {
                URI apiURI = new URI(apiUrl);
                URL rfc8414URL = new URI(apiURI.getScheme(), apiURI.getHost(), "/.well-known/oauth-authorization-server", null).toURL();
                client = HttpClient.create(rfc8414URL);
                HttpClient.Response response = client.connect();
                if (response.getResponseCode() != 200) break block21;
                try (BufferedReader reader = response.getContentReader();
                     JsonReader jsonReader = Json.createReader(reader);){
                    JsonStructure structure = jsonReader.read();
                    if (structure.getValueType() == JsonValue.ValueType.OBJECT) {
                        JsonObject jsonObject = structure.asJsonObject();
                        return jsonObject;
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new JosmRuntimeException(e);
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        }
        return Json.createObjectBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OAuth20Parameters getDefaultOAuth20Parameters(String apiUrl) {
        String clientSecret;
        String clientId;
        String redirectUri = "http://127.0.0.1:8111/oauth_authorization";
        apiUrl = apiUrl == null ? OsmApi.getOsmApi().getServerUrl() : apiUrl;
        switch (apiUrl) {
            case "https://api06.dev.openstreetmap.org/api": 
            case "https://master.apis.dev.openstreetmap.org/api": {
                clientId = "-QZt6n1btDfqrfJNGUIMZjzcyqTgIV6sy79_W4kmQLM";
                clientSecret = "SWnmRD4AdLO-2-ttHE5TR3eLF2McNf7dh0_Z2WNzJdI";
                break;
            }
            case "https://api.openstreetmap.org/api": {
                clientId = "edPII614Lm0_0zEpc_QzEltA9BUll93-Y-ugRQUoHMI";
                clientSecret = null;
                break;
            }
            case "https://www.openhistoricalmap.org/api": {
                clientId = "Hl5yIhFS-Egj6aY7A35ouLOuZl0EHjj8JJQQ46IO96E";
                clientSecret = null;
                break;
            }
            default: {
                clientId = "";
                clientSecret = null;
            }
        }
        String baseUrl = apiUrl;
        try {
            Object object = RFC8414_RESPONSES;
            synchronized (object) {
                JsonObject data = NetworkManager.isOffline(apiUrl) ? null : RFC8414_RESPONSES.computeIfAbsent(apiUrl, OAuthParameters::getRFC8414Parameters);
                if (data != null && !data.isEmpty()) {
                    return OAuthParameters.parseAuthorizationServerMetadataResponse(clientId, clientSecret, apiUrl, "http://127.0.0.1:8111/oauth_authorization", data);
                }
                RFC8414_RESPONSES.remove(apiUrl);
            }
        }
        catch (JosmRuntimeException e) {
            if (e.getCause() instanceof URISyntaxException || e.getCause() instanceof IOException) {
                Logging.trace(e);
            }
            throw e;
        }
        catch (OAuthException e) {
            Logging.trace(e);
        }
        return new OAuth20Parameters(clientId, clientSecret, baseUrl, apiUrl, "http://127.0.0.1:8111/oauth_authorization");
    }

    private static OAuth20Parameters parseAuthorizationServerMetadataResponse(String clientId, String clientSecret, String apiUrl, String redirectUri, JsonObject serverMetadata) throws OAuthException {
        String authorizationEndpoint = serverMetadata.getString("authorization_endpoint", null);
        String tokenEndpoint = serverMetadata.getString("token_endpoint", null);
        if (authorizationEndpoint == null || tokenEndpoint == null) {
            throw new OAuth20Exception("Either token endpoint or authorization endpoints are missing");
        }
        return new OAuth20Parameters(clientId, clientSecret, tokenEndpoint, authorizationEndpoint, apiUrl, redirectUri);
    }

    public static IOAuthParameters createFromApiUrl(String apiUrl, OAuthVersion oAuthVersion) {
        if (apiUrl.startsWith("https://") || apiUrl.startsWith("http://")) {
            try {
                apiUrl = new URI(apiUrl).getHost();
            }
            catch (URISyntaxException syntaxException) {
                Logging.trace(apiUrl);
            }
        }
        switch (oAuthVersion) {
            case OAuth20: 
            case OAuth21: {
                try {
                    IOAuthToken storedToken = CredentialsManager.getInstance().lookupOAuthAccessToken(apiUrl);
                    if (storedToken != null) {
                        return storedToken.getParameters();
                    }
                }
                catch (CredentialsAgentException e) {
                    Logging.trace(e);
                }
                return OAuthParameters.createDefault(apiUrl, oAuthVersion);
            }
        }
        throw new IllegalArgumentException("Unknown OAuth version: " + (Object)((Object)oAuthVersion));
    }
}

