/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.data.preferences.JosmUrls;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.BasicAuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.OAuthAuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class AuthenticationPreferencesPanel
extends VerticallyScrollablePanel
implements PropertyChangeListener {
    private final JRadioButton rbBasicAuthentication = new JRadioButton();
    private final JRadioButton rbOAuth = new JRadioButton();
    private final JRadioButton rbOAuth20 = new JRadioButton();
    private final JPanel pnlAuthenticationParameters = new JPanel(new BorderLayout());
    private BasicAuthenticationPreferencesPanel pnlBasicAuthPreferences;
    private OAuthAuthenticationPreferencesPanel pnlOAuthPreferences;
    private OAuthAuthenticationPreferencesPanel pnlOAuth20Preferences;
    private String apiUrl = OsmApi.getOsmApi().getServerUrl();
    private final ExpertToggleAction.ExpertModeChangeListener expertModeChangeListener = isExpert -> {
        String authMethod = OsmApi.getAuthMethod();
        boolean defaultApi = JosmUrls.getInstance().getDefaultOsmApiUrl().equals(this.apiUrl);
        this.rbBasicAuthentication.setEnabled(this.rbBasicAuthentication.isSelected() || "basic".equals(authMethod) || isExpert || !defaultApi);
        this.rbOAuth.setEnabled(this.rbOAuth.isSelected() || "oauth".equals(authMethod) || isExpert || !defaultApi);
    };

    public AuthenticationPreferencesPanel() {
        this.build();
        this.initFromPreferences();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#AuthenticationSettings"));
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        AuthenticationMethodChangeListener authChangeListener = new AuthenticationMethodChangeListener();
        JPanel buttonPanel = new JPanel(new FlowLayout(3));
        buttonPanel.add(this.rbBasicAuthentication);
        this.rbBasicAuthentication.setText(I18n.tr("Use Basic Authentication", new Object[0]));
        this.rbBasicAuthentication.setToolTipText(I18n.tr("Select to use HTTP basic authentication with your OSM username and password", new Object[0]));
        this.rbBasicAuthentication.addItemListener(authChangeListener);
        buttonPanel.add(this.rbOAuth);
        this.rbOAuth.setText(I18n.tr("Use OAuth {0}", "1.0a"));
        this.rbOAuth.setToolTipText(I18n.tr("Select to use OAuth {0} as authentication mechanism", "1.0a"));
        this.rbOAuth.addItemListener(authChangeListener);
        buttonPanel.add(this.rbOAuth20);
        this.rbOAuth20.setText(I18n.tr("Use OAuth {0}", "2.0"));
        this.rbOAuth20.setToolTipText(I18n.tr("Select to use OAuth {0} as authentication mechanism", "2.0"));
        this.rbOAuth20.addItemListener(authChangeListener);
        this.add((Component)buttonPanel, GBC.eol());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbBasicAuthentication);
        bg.add(this.rbOAuth);
        bg.add(this.rbOAuth20);
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.insets = new Insets(0, 0, 0, 3);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)this.pnlAuthenticationParameters, gc);
        this.pnlBasicAuthPreferences = new BasicAuthenticationPreferencesPanel();
        this.pnlOAuthPreferences = new OAuthAuthenticationPreferencesPanel(OAuthVersion.OAuth10a);
        this.pnlOAuth20Preferences = new OAuthAuthenticationPreferencesPanel(OAuthVersion.OAuth20);
        ExpertToggleAction.addExpertModeChangeListener(this.expertModeChangeListener, true);
        this.rbOAuth20.setSelected(true);
        this.pnlAuthenticationParameters.add((Component)this.pnlOAuth20Preferences, "Center");
    }

    public final void initFromPreferences() {
        String authMethod;
        switch (authMethod = OsmApi.getAuthMethod()) {
            case "basic": {
                this.rbBasicAuthentication.setSelected(true);
                break;
            }
            case "oauth": {
                this.rbOAuth.setSelected(true);
                break;
            }
            case "oauth20": {
                this.rbOAuth20.setSelected(true);
                break;
            }
            default: {
                Logging.warn(I18n.tr("Unsupported value in preference ''{0}'', got ''{1}''. Using authentication method ''Basic Authentication''.", "osm-server.auth-method", authMethod));
                this.rbBasicAuthentication.setSelected(true);
            }
        }
        this.pnlBasicAuthPreferences.initFromPreferences();
        this.pnlOAuthPreferences.initFromPreferences();
        this.pnlOAuth20Preferences.initFromPreferences();
    }

    public final void saveToPreferences() {
        String authMethod;
        if (this.rbBasicAuthentication.isSelected()) {
            authMethod = "basic";
        } else if (this.rbOAuth.isSelected()) {
            authMethod = "oauth";
        } else if (this.rbOAuth20.isSelected()) {
            authMethod = "oauth20";
        } else {
            throw new IllegalStateException("One of OAuth 2.0, OAuth 1.0a, or Basic authentication must be checked");
        }
        boolean initUser = Config.getPref().put("osm-server.auth-method", authMethod);
        if ("basic".equals(authMethod)) {
            this.pnlBasicAuthPreferences.saveToPreferences();
            OAuthAccessTokenHolder.getInstance().clear();
            OAuthAccessTokenHolder.getInstance().save(CredentialsManager.getInstance());
        } else if ("oauth".equals(authMethod)) {
            this.pnlBasicAuthPreferences.clearPassword();
            this.pnlBasicAuthPreferences.saveToPreferences();
            this.pnlOAuthPreferences.saveToPreferences();
        } else {
            this.pnlBasicAuthPreferences.clearPassword();
            this.pnlBasicAuthPreferences.saveToPreferences();
            this.pnlOAuth20Preferences.saveToPreferences();
        }
        if (initUser) {
            if ("basic".equals(authMethod)) {
                UserIdentityManager.getInstance().initFromPreferences();
            } else {
                UserIdentityManager.getInstance().initFromOAuth();
            }
        }
        ExpertToggleAction.removeExpertModeChangeListener(this.expertModeChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.pnlOAuthPreferences != null) {
            this.pnlOAuthPreferences.propertyChange(evt);
        }
        if (this.pnlOAuth20Preferences != null) {
            this.pnlOAuth20Preferences.propertyChange(evt);
        }
        if (OsmApiUrlInputPanel.API_URL_PROP.equals(evt.getPropertyName())) {
            this.apiUrl = (String)evt.getNewValue();
            this.expertModeChangeListener.expertChanged(ExpertToggleAction.isExpert());
        }
    }

    class AuthenticationMethodChangeListener
    implements ItemListener {
        AuthenticationMethodChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AuthenticationPreferencesPanel.this.pnlAuthenticationParameters.removeAll();
            if (AuthenticationPreferencesPanel.this.rbBasicAuthentication.isSelected()) {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameters.add((Component)AuthenticationPreferencesPanel.this.pnlBasicAuthPreferences, "Center");
                AuthenticationPreferencesPanel.this.pnlBasicAuthPreferences.revalidate();
            } else if (AuthenticationPreferencesPanel.this.rbOAuth.isSelected()) {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameters.add((Component)AuthenticationPreferencesPanel.this.pnlOAuthPreferences, "Center");
                AuthenticationPreferencesPanel.this.pnlOAuthPreferences.saveToPreferences();
                AuthenticationPreferencesPanel.this.pnlOAuthPreferences.initFromPreferences();
                AuthenticationPreferencesPanel.this.pnlOAuthPreferences.revalidate();
            } else if (AuthenticationPreferencesPanel.this.rbOAuth20.isSelected()) {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameters.add((Component)AuthenticationPreferencesPanel.this.pnlOAuth20Preferences, "Center");
                AuthenticationPreferencesPanel.this.pnlOAuth20Preferences.saveToPreferences();
                AuthenticationPreferencesPanel.this.pnlOAuth20Preferences.initFromPreferences();
                AuthenticationPreferencesPanel.this.pnlOAuth20Preferences.revalidate();
            }
            AuthenticationPreferencesPanel.this.repaint();
        }
    }
}

