/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.gui.layer.geoimage.ImageUtils;

public interface ImageMetadata {
    public URI getImageURI();

    public int getWidth();

    public int getHeight();

    public ILatLon getPos();

    public Double getSpeed();

    public Double getElevation();

    public Instant getGpsInstant();

    public boolean hasGpsTime();

    public String getDisplayName();

    default public Integer getExifOrientation() {
        return 1;
    }

    public Instant getExifInstant();

    public boolean hasExifTime();

    public Instant getExifGpsInstant();

    public boolean hasExifGpsTime();

    public ILatLon getExifCoor();

    public Double getExifImgDir();

    public Instant getLastModified();

    public void setWidth(int var1);

    public void setHeight(int var1);

    public void setPos(ILatLon var1);

    public void setSpeed(Double var1);

    public void setElevation(Double var1);

    public void setExifOrientation(Integer var1);

    public void setExifTime(Instant var1);

    public void setExifGpsTime(Instant var1);

    public void setGpsTime(Instant var1);

    public void setExifCoor(ILatLon var1);

    public void setExifImgDir(Double var1);

    public void setIptcCaption(String var1);

    public void setIptcHeadline(String var1);

    public void setIptcKeywords(List<String> var1);

    public void setIptcObjectName(String var1);

    public String getIptcCaption();

    public String getIptcHeadline();

    public List<String> getIptcKeywords();

    public String getIptcObjectName();

    default public void extractExif() {
        try (InputStream original = this.getInputStream();
             BufferedInputStream bufferedInputStream = new BufferedInputStream(original);){
            ImageUtils.applyExif(this, bufferedInputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public InputStream getInputStream() throws IOException;

    public Projections getProjectionType();

    public void setProjectionType(Projections var1);
}

