/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.stream.Stream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.gui.history.CoordinateInfoViewer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.NodeListViewer;
import org.openstreetmap.josm.gui.history.RelationMemberListViewer;
import org.openstreetmap.josm.gui.history.TagInfoViewer;
import org.openstreetmap.josm.gui.history.VersionTable;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowser
extends JPanel
implements Destroyable {
    private transient HistoryBrowserModel model = new HistoryBrowserModel();
    private TagInfoViewer tagInfoViewer;
    private NodeListViewer nodeListViewer;
    private RelationMemberListViewer relationMemberListViewer;
    private CoordinateInfoViewer coordinateInfoViewer;
    private JTabbedPane tpViewers;

    public HistoryBrowser() {
        this.build();
    }

    public HistoryBrowser(History history) {
        this();
        this.populate(history);
    }

    protected JPanel createVersionTablePanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)new JScrollPane(new VersionTable(this.model)), "Center");
        return pnl;
    }

    protected JPanel createVersionComparePanel() {
        this.tpViewers = new JTabbedPane();
        this.tagInfoViewer = new TagInfoViewer(this.model);
        this.nodeListViewer = new NodeListViewer(this.model);
        this.relationMemberListViewer = new RelationMemberListViewer(this.model);
        this.coordinateInfoViewer = new CoordinateInfoViewer(this.model);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.tpViewers, "Center");
        this.tpViewers.addChangeListener(e -> {
            if (this.tpViewers.getSelectedComponent() == this.coordinateInfoViewer) {
                this.coordinateInfoViewer.setDisplayToFitMapMarkers();
            }
        });
        return pnl;
    }

    protected void build() {
        JPanel left = this.createVersionTablePanel();
        JPanel right = this.createVersionComparePanel();
        this.setLayout(new BorderLayout());
        JSplitPane pane = new JSplitPane(1, left, right);
        this.add((Component)pane, "Center");
        pane.setOneTouchExpandable(true);
        pane.setDividerLocation(300);
        Dimension minimumSize = new Dimension(100, 50);
        left.setMinimumSize(minimumSize);
        right.setMinimumSize(minimumSize);
    }

    public void populate(History history) {
        boolean samePrimitive = this.model.isSamePrimitive(history);
        this.model.setHistory(history);
        if (samePrimitive) {
            return;
        }
        this.tpViewers.removeAll();
        this.tpViewers.add(this.tagInfoViewer);
        this.tpViewers.setTitleAt(0, I18n.tr("Tags", new Object[0]));
        if (history.getEarliest().getType() == OsmPrimitiveType.NODE) {
            this.tpViewers.add(this.coordinateInfoViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Coordinates", new Object[0]));
        } else if (history.getEarliest().getType() == OsmPrimitiveType.WAY) {
            this.tpViewers.add(this.nodeListViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Nodes", new Object[0]));
        } else if (history.getEarliest().getType() == OsmPrimitiveType.RELATION) {
            this.tpViewers.add(this.relationMemberListViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Members", new Object[0]));
        }
        this.revalidate();
    }

    public History getHistory() {
        return this.model.getHistory();
    }

    public HistoryBrowserModel getModel() {
        return this.model;
    }

    @Override
    public void destroy() {
        if (this.model != null) {
            this.model.unlinkAsListener();
            this.model = null;
        }
        Stream.of(this.tagInfoViewer, this.nodeListViewer, this.relationMemberListViewer, this.coordinateInfoViewer).filter(Destroyable.class::isInstance).forEach(Destroyable::destroy);
        this.tagInfoViewer = null;
        this.nodeListViewer = null;
        this.relationMemberListViewer = null;
        this.coordinateInfoViewer = null;
    }
}

