/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class LateralCacheNoWaitFacade<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(LateralCacheNoWaitFacade.class);
    @Deprecated
    public LateralCacheNoWait<K, V>[] noWaits;
    private final ConcurrentHashMap<String, LateralCacheNoWait<K, V>> noWaitMap;
    private final String cacheName;
    private ILateralCacheListener<K, V> listener;
    private final ILateralCacheAttributes lateralCacheAttributes;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    @Deprecated
    public LateralCacheNoWaitFacade(ILateralCacheListener<K, V> listener, LateralCacheNoWait<K, V>[] noWaits, ILateralCacheAttributes cattr) {
        this(listener, Arrays.asList(noWaits), cattr);
    }

    public LateralCacheNoWaitFacade(ILateralCacheListener<K, V> listener, List<LateralCacheNoWait<K, V>> noWaits, ILateralCacheAttributes cattr) {
        log.debug("CONSTRUCTING NO WAIT FACADE");
        this.listener = listener;
        this.noWaits = noWaits.toArray(new LateralCacheNoWait[noWaits.size()]);
        this.noWaitMap = new ConcurrentHashMap();
        noWaits.forEach(noWait -> this.noWaitMap.put(noWait.getIdentityKey(), (LateralCacheNoWait<String, LateralCacheNoWait>)noWait));
        this.cacheName = cattr.getCacheName();
        this.lateralCacheAttributes = cattr;
    }

    protected int getNoWaitSize() {
        return this.noWaitMap.size();
    }

    public boolean containsNoWait(LateralCacheNoWait<K, V> noWait) {
        return this.containsNoWait(noWait.getIdentityKey());
    }

    public boolean containsNoWait(String tcpServer) {
        return this.noWaitMap.containsKey(tcpServer);
    }

    public synchronized boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        if (noWait == null) {
            return false;
        }
        LateralCacheNoWait<K, V> added = this.noWaitMap.putIfAbsent(noWait.getIdentityKey(), noWait);
        if (added != null) {
            log.debug("No Wait already contained, [{0}]", noWait);
            return false;
        }
        this.noWaits = this.noWaitMap.values().toArray(new LateralCacheNoWait[0]);
        return true;
    }

    public synchronized boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        if (noWait == null) {
            return false;
        }
        return this.removeNoWait(noWait.getIdentityKey());
    }

    public synchronized boolean removeNoWait(String tcpServer) {
        if (tcpServer == null) {
            return false;
        }
        LateralCacheNoWait<K, V> contained = this.noWaitMap.remove(tcpServer);
        this.noWaits = this.noWaitMap.values().toArray(new LateralCacheNoWait[0]);
        if (contained != null) {
            contained.dispose();
        }
        return contained != null;
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.noWaitMap::size;
        log.debug("updating through lateral cache facade, noWaits.length = {0}", supplierArray);
        for (LateralCacheNoWait<K, V> nw : this.noWaitMap.values()) {
            nw.update(ce);
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        return this.noWaitMap.values().stream().map(nw -> nw.get(key)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            return keys.stream().collect(Collectors.toMap(key -> key, this::get)).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return new HashMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        return this.noWaitMap.values().stream().flatMap(nw -> nw.getMatching(pattern).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> allKeys = new HashSet<K>();
        for (LateralCacheNoWait<K, V> nw : this.noWaitMap.values()) {
            Set<K> keys = nw.getKeySet();
            if (keys == null) continue;
            allKeys.addAll(keys);
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        this.noWaitMap.values().forEach(nw -> nw.remove(key));
        return false;
    }

    @Override
    public void removeAll() {
        this.noWaitMap.values().forEach(LateralCacheNoWait::removeAll);
    }

    @Override
    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            if (this.listener != null) {
                this.listener.dispose();
                this.listener = null;
            }
            this.noWaitMap.values().forEach(LateralCacheNoWait::dispose);
            this.noWaitMap.clear();
        }
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.LATERAL_CACHE;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public CacheStatus getStatus() {
        if (this.disposed.get()) {
            return CacheStatus.DISPOSED;
        }
        if (this.noWaitMap.isEmpty() || this.listener != null) {
            return CacheStatus.ALIVE;
        }
        List statii = this.noWaitMap.values().stream().map(LateralCacheNoWait::getStatus).collect(Collectors.toList());
        if (statii.contains((Object)CacheStatus.ALIVE)) {
            return CacheStatus.ALIVE;
        }
        if (statii.contains((Object)CacheStatus.ERROR)) {
            return CacheStatus.ERROR;
        }
        return CacheStatus.DISPOSED;
    }

    @Override
    public ILateralCacheAttributes getAuxiliaryCacheAttributes() {
        return this.lateralCacheAttributes;
    }

    public String toString() {
        return "LateralCacheNoWaitFacade: " + this.cacheName;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Lateral Cache No Wait";
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait Facade");
        ArrayList elems = new ArrayList();
        if (this.noWaitMap != null) {
            elems.add(new StatElement<Integer>("Number of No Waits", this.noWaitMap.size()));
            elems.addAll(this.noWaitMap.values().stream().flatMap(lcnw -> lcnw.getStatistics().getStatElements().stream()).collect(Collectors.toList()));
        }
        stats.setStatElements(elems);
        return stats;
    }
}

