/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetListEntry;
import org.openstreetmap.josm.gui.widgets.JosmListCellRenderer;
import org.openstreetmap.josm.gui.widgets.OrientationAction;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class ComboMultiSelect
extends KeyedItem {
    public String values;
    public String values_from;
    public String values_context;
    public boolean values_no_i18n;
    public boolean values_sort = true;
    public String display_values;
    public String locale_display_values;
    public String short_descriptions;
    public String locale_short_descriptions;
    public String default_;
    public char delimiter = (char)59;
    public byte use_last_as_default;
    public boolean values_searchable;
    protected final List<PresetListEntry> presetListEntries = new ArrayList<PresetListEntry>();
    protected final Map<String, PresetListEntry> seenValues = new TreeMap<String, PresetListEntry>();
    protected KeyedItem.Usage usage;
    protected String originalValue;

    public static List<String> splitEscaped(char delimiter, String s) {
        if (s == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean backslash = false;
        StringBuilder item = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (backslash) {
                item.append(ch);
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            if (ch == delimiter) {
                result.add(item.toString());
                item.setLength(0);
                continue;
            }
            item.append(ch);
        }
        if (item.length() > 0) {
            result.add(item.toString());
        }
        return result;
    }

    protected abstract PresetListEntry getSelectedItem();

    @Override
    public Collection<String> getValues() {
        this.initListEntries();
        return this.presetListEntries.stream().map(x -> x.value).collect(Collectors.toSet());
    }

    public Collection<String> getDisplayValues() {
        this.initListEntries();
        return this.presetListEntries.stream().map(PresetListEntry::getDisplayValue).collect(Collectors.toList());
    }

    protected JLabel addLabel(JPanel p) {
        JLabel label = new JLabel(I18n.tr("{0}:", this.locale_text));
        this.addIcon(label);
        label.setToolTipText(this.getKeyTooltipText());
        label.setComponentPopupMenu(this.getPopupMenu());
        label.applyComponentOrientation(OrientationAction.getDefaultComponentOrientation());
        p.add((Component)label, GBC.std().insets(0, 0, 10, 0));
        return label;
    }

    protected void initListEntries() {
        if (this.presetListEntries.isEmpty()) {
            this.initListEntriesFromAttributes();
        }
    }

    private List<String> getValuesFromCode(String valuesFrom) {
        String[] classMethod = valuesFrom.split("#", -1);
        if (classMethod.length == 2) {
            try {
                Method method = Class.forName(classMethod[0]).getMethod(classMethod[1], new Class[0]);
                int mod = method.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && method.getReturnType().equals(String[].class) && method.getParameterTypes().length == 0) {
                    return Arrays.asList((String[])method.invoke(null, new Object[0]));
                }
                Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' is not \"{2}\"", this.key, this.text, "public static String[] methodName()"));
            }
            catch (ReflectiveOperationException e) {
                Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' threw {2} ({3})", this.key, this.text, e.getClass().getName(), e.getMessage()));
                Logging.debug(e);
            }
        }
        return null;
    }

    private List<String> checkListsSameLength(List<String> a, List<String> b, String name) {
        if (a != null && a.size() != b.size()) {
            Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''{2}'' must be the same as in ''values''", this.key, this.text, name));
            Logging.error(I18n.tr("Detailed information: {0} <> {1}", a, b));
            return null;
        }
        return a;
    }

    protected void initListEntriesFromAttributes() {
        List<String> valueList = null;
        List<String> displayList = null;
        List<String> localeDisplayList = null;
        if (this.values_from != null) {
            valueList = this.getValuesFromCode(this.values_from);
        }
        if (valueList == null) {
            valueList = ComboMultiSelect.splitEscaped(this.delimiter, this.values);
        }
        if (valueList == null) {
            return;
        }
        if (!this.values_no_i18n) {
            localeDisplayList = ComboMultiSelect.splitEscaped(this.delimiter, this.locale_display_values);
            displayList = ComboMultiSelect.splitEscaped(this.delimiter, this.display_values);
        }
        List<String> localeShortDescriptionsList = ComboMultiSelect.splitEscaped(this.delimiter, this.locale_short_descriptions);
        List<String> shortDescriptionsList = ComboMultiSelect.splitEscaped(this.delimiter, this.short_descriptions);
        displayList = this.checkListsSameLength(displayList, valueList, "display_values");
        localeDisplayList = this.checkListsSameLength(localeDisplayList, valueList, "locale_display_values");
        shortDescriptionsList = this.checkListsSameLength(shortDescriptionsList, valueList, "short_descriptions");
        localeShortDescriptionsList = this.checkListsSameLength(localeShortDescriptionsList, valueList, "locale_short_descriptions");
        for (int i = 0; i < valueList.size(); ++i) {
            PresetListEntry e = new PresetListEntry(valueList.get(i), this);
            if (displayList != null) {
                e.display_value = displayList.get(i);
            }
            if (localeDisplayList != null) {
                e.locale_display_value = localeDisplayList.get(i);
            }
            if (shortDescriptionsList != null) {
                e.short_description = shortDescriptionsList.get(i);
            }
            if (localeShortDescriptionsList != null) {
                e.locale_short_description = localeShortDescriptionsList.get(i);
            }
            this.addListEntry(e);
        }
        if (this.values_sort && TaggingPresets.SORT_MENU.get().booleanValue()) {
            Collections.sort(this.presetListEntries, (a, b) -> AlphanumComparator.getInstance().compare(a.getDisplayValue(), b.getDisplayValue()));
        }
    }

    protected String getInitialValue(KeyedItem.Usage usage, TaggingPresetItemGuiSupport support) {
        String initialValue = null;
        this.originalValue = "";
        if (usage.hasUniqueValue()) {
            this.originalValue = initialValue = usage.getFirst();
        } else if (!usage.unused()) {
            this.originalValue = initialValue = "<different>";
        } else if (!usage.hadKeys() || this.isForceUseLastAsDefault() || PROP_FILL_DEFAULT.get().booleanValue()) {
            initialValue = !support.isPresetInitiallyMatches() && this.isUseLastAsDefault() && LAST_VALUES.containsKey(this.key) ? (String)LAST_VALUES.get(this.key) : this.default_;
        }
        return initialValue != null ? initialValue : "";
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        String value = this.getSelectedItem().value;
        if (value.equals(this.originalValue)) {
            return;
        }
        changedTags.add(new Tag(this.key, value));
        if (this.isUseLastAsDefault()) {
            LAST_VALUES.put(this.key, value);
        }
    }

    public void setUse_last_as_default(String v) {
        this.use_last_as_default = "force".equals(v) ? (byte)2 : ("true".equals(v) ? (byte)1 : 0);
    }

    protected boolean isUseLastAsDefault() {
        return this.use_last_as_default > 0;
    }

    protected boolean isForceUseLastAsDefault() {
        return this.use_last_as_default == 2;
    }

    public void addListEntry(PresetListEntry e) {
        this.presetListEntries.add(e);
        e.cms = this;
    }

    public void addListEntries(Collection<PresetListEntry> e) {
        for (PresetListEntry i : e) {
            this.addListEntry(i);
        }
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    static class ComboMultiSelectListCellRenderer
    extends JosmListCellRenderer<PresetListEntry> {
        int width;
        private String key;

        ComboMultiSelectListCellRenderer(Component component, ListCellRenderer<? super PresetListEntry> renderer, int width, String key) {
            super(component, renderer);
            this.key = key;
            this.setWidth(width);
        }

        public void setWidth(int width) {
            if (width <= 0) {
                width = 200;
            }
            this.width = width - 20;
        }

        public JLabel getListCellRendererComponent(JList<? extends PresetListEntry> list, PresetListEntry value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            l.setComponentOrientation(this.component.getComponentOrientation());
            if (index != -1) {
                l.setText(value.getListDisplay(this.width));
            }
            if (value.getCount() > 0) {
                l.setFont(l.getFont().deriveFont(3));
            }
            l.setIcon(value.getIcon());
            l.setToolTipText(value.getToolTipText(this.key));
            return l;
        }
    }
}

