/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.DefaultMarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class Marker
implements TemplateEngineDataProvider,
ILatLon,
Destroyable {
    private static final List<MarkerProducers> markerProducers = new LinkedList<MarkerProducers>();
    public static final String MARKER_OFFSET = "waypointOffset";
    public static final String MARKER_FORMATTED_OFFSET = "formattedWaypointOffset";
    public static final String LABEL_PATTERN_AUTO = "?{ '{name} ({desc})' | '{name} ({cmt})' | '{name}' | '{desc}' | '{cmt}' }";
    public static final String LABEL_PATTERN_NAME = "{name}";
    public static final String LABEL_PATTERN_DESC = "{desc}";
    private final TemplateEngineDataProvider dataProvider;
    private final String text;
    protected final ImageIcon symbol;
    private BufferedImage redSymbol;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private String cachedText;
    private static Map<GpxLayer, String> cachedTemplates;
    private String cachedDefaultTemplate;
    private CachedLatLon coor;
    private PreferenceChangedListener listener = l -> this.updateText();
    private boolean erroneous;

    public static void appendMarkerProducer(MarkerProducers mp) {
        markerProducers.add(mp);
    }

    public static void prependMarkerProducer(MarkerProducers mp) {
        markerProducers.add(0, mp);
    }

    public static Collection<Marker> createMarkers(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
        return markerProducers.stream().map(maker -> maker.createMarkers(wpt, relativePath, parentLayer, time, offset)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Marker(LatLon ll, TemplateEngineDataProvider dataProvider, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this(ll, dataProvider, null, iconName, parentLayer, time, offset);
    }

    public Marker(LatLon ll, String text, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this(ll, null, text, iconName, parentLayer, time, offset);
    }

    private Marker(LatLon ll, TemplateEngineDataProvider dataProvider, String text, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this.setCoor(ll);
        this.offset = offset;
        this.time = time;
        this.symbol = iconName != null ? ImageProvider.getIfAvailable("markers", iconName) : null;
        this.parentLayer = parentLayer;
        this.dataProvider = dataProvider;
        this.text = text;
        Preferences.main().addKeyPreferenceChangeListener(this.getPreferenceKey(), this.listener);
    }

    public WayPoint convertToWayPoint() {
        WayPoint wpt = new WayPoint(this.getCoor());
        if (this.time > 0.0) {
            wpt.setTimeInMillis((long)(this.time * 1000.0));
        }
        if (this.text != null) {
            wpt.getExtensions().add("josm", "text", this.text);
        } else if (this.dataProvider != null) {
            for (String key : this.dataProvider.getTemplateKeys()) {
                Object value = this.dataProvider.getTemplateValue(key, false);
                if (value == null || !GpxConstants.WPT_KEYS.contains(key)) continue;
                wpt.put(key, value);
            }
        }
        return wpt;
    }

    public final void setCoor(LatLon coor) {
        this.coor = new CachedLatLon(coor);
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor = new CachedLatLon(eastNorth);
    }

    @Override
    public double lon() {
        return this.coor == null ? Double.NaN : this.coor.lon();
    }

    @Override
    public double lat() {
        return this.coor == null ? Double.NaN : this.coor.lat();
    }

    public boolean containsPoint(Point p) {
        return false;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void paint(Graphics2D g, MapView mv, boolean mousePressed, boolean showTextOrIcon) {
        Point screen = mv.getPoint(this);
        int size2 = this.parentLayer.markerSize / 2;
        if (this.symbol != null && showTextOrIcon) {
            this.paintIcon(mv, g, screen.x - this.symbol.getIconWidth() / 2, screen.y - this.symbol.getIconHeight() / 2);
        } else {
            Stroke stroke = g.getStroke();
            g.setStroke(this.parentLayer.markerStroke);
            g.drawLine(screen.x - size2, screen.y - size2, screen.x + size2, screen.y + size2);
            g.drawLine(screen.x + size2, screen.y - size2, screen.x - size2, screen.y + size2);
            g.setStroke(stroke);
        }
        String labelText = this.getText();
        if (!labelText.isEmpty() && showTextOrIcon) {
            g.drawString(labelText, screen.x + size2 + 2, screen.y + size2);
        }
    }

    protected void paintIcon(MapView mv, Graphics g, int x, int y) {
        if (!this.erroneous) {
            this.symbol.paintIcon(mv, g, x, y);
        } else {
            if (this.redSymbol == null) {
                int width = this.symbol.getIconWidth();
                int height = this.symbol.getIconHeight();
                this.redSymbol = new BufferedImage(width, height, 2);
                Graphics2D gbi = this.redSymbol.createGraphics();
                gbi.drawImage(this.symbol.getImage(), 0, 0, null);
                gbi.setColor(Color.RED);
                gbi.setComposite(AlphaComposite.getInstance(10, 0.666f));
                gbi.fillRect(0, 0, width, height);
                gbi.dispose();
            }
            g.drawImage(this.redSymbol, x, y, mv);
        }
    }

    protected String getTextTemplateKey() {
        return "markers.pattern";
    }

    private String getTextTemplate() {
        String tmpl;
        if (cachedTemplates.containsKey(this.parentLayer.fromLayer)) {
            tmpl = cachedTemplates.get(this.parentLayer.fromLayer);
        } else {
            tmpl = GPXSettingsPanel.getLayerPref(this.parentLayer.fromLayer, this.getTextTemplateKey());
            cachedTemplates.put(this.parentLayer.fromLayer, tmpl);
        }
        return tmpl;
    }

    private String getDefaultTextTemplate() {
        if (this.cachedDefaultTemplate == null) {
            this.cachedDefaultTemplate = GPXSettingsPanel.getLayerPref(null, this.getTextTemplateKey());
        }
        return this.cachedDefaultTemplate;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.cachedText == null) {
            TemplateEntry template;
            String templateString = this.getTextTemplate();
            try {
                template = new TemplateParser(templateString).parse();
            }
            catch (ParseError e) {
                Logging.debug(e);
                String def = this.getDefaultTextTemplate();
                Logging.warn("Unable to parse template engine pattern ''{0}'' for property {1}. Using default (''{2}'') instead", templateString, this.getTextTemplateKey(), def);
                try {
                    template = new TemplateParser(def).parse();
                }
                catch (ParseError e1) {
                    Logging.error(e1);
                    this.cachedText = "";
                    return "";
                }
            }
            StringBuilder sb = new StringBuilder();
            template.appendText(sb, this);
            this.cachedText = sb.toString();
        }
        return this.cachedText;
    }

    public void updateText() {
        this.cachedText = null;
        this.cachedDefaultTemplate = null;
        cachedTemplates.clear();
    }

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> result = this.dataProvider != null ? this.dataProvider.getTemplateKeys() : new ArrayList<String>();
        result.add(MARKER_FORMATTED_OFFSET);
        result.add(MARKER_OFFSET);
        return result;
    }

    private String formatOffset() {
        int wholeSeconds = (int)(this.offset + 0.5);
        if (wholeSeconds < 60) {
            return Integer.toString(wholeSeconds);
        }
        if (wholeSeconds < 3600) {
            return String.format("%d:%02d", wholeSeconds / 60, wholeSeconds % 60);
        }
        return String.format("%d:%02d:%02d", wholeSeconds / 3600, wholeSeconds % 3600 / 60, wholeSeconds % 60);
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (MARKER_FORMATTED_OFFSET.equals(name)) {
            return this.formatOffset();
        }
        if (MARKER_OFFSET.equals(name)) {
            return this.offset;
        }
        if (this.dataProvider != null) {
            return this.dataProvider.getTemplateValue(name, special);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        throw new UnsupportedOperationException();
    }

    public final boolean isErroneous() {
        return this.erroneous;
    }

    public final void setErroneous(boolean erroneous) {
        this.erroneous = erroneous;
        if (!erroneous) {
            this.redSymbol = null;
        }
    }

    @Override
    public void destroy() {
        cachedTemplates.clear();
        Preferences.main().removeKeyPreferenceChangeListener(this.getPreferenceKey(), this.listener);
    }

    private String getPreferenceKey() {
        return "draw.rawgps." + this.getTextTemplateKey();
    }

    static {
        markerProducers.add(new DefaultMarkerProducers());
        cachedTemplates = new HashMap<GpxLayer, String>();
    }
}

