/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadDialogModel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.io.UploadTextComponentValidator;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class BasicUploadSettingsPanel
extends JPanel
implements ActionListener,
FocusListener,
ItemListener,
KeyListener,
TableModelListener {
    public static final String COMMENT_HISTORY_KEY = "upload.comment.history";
    public static final String COMMENT_LAST_USED_KEY = "upload.comment.last-used";
    public static final String COMMENT_MAX_AGE_KEY = "upload.comment.max-age";
    public static final String SOURCE_HISTORY_KEY = "upload.source.history";
    private final HistoryComboBox hcbUploadComment = new HistoryComboBox();
    private final HistoryComboBox hcbUploadSource = new HistoryComboBox();
    private final transient JCheckBox obtainSourceAutomatically = new JCheckBox(I18n.tr("Automatically obtain source from current layers", new Object[0]));
    private final UploadParameterSummaryPanel pnlUploadParameterSummary = new UploadParameterSummaryPanel();
    private final JCheckBox cbRequestReview = new JCheckBox(I18n.tr("I would like someone to review my edits.", new Object[0]));
    private final JLabel areaValidatorFeedback = new JLabel();
    private final UploadTextComponentValidator.UploadAreaValidator areaValidator = new UploadTextComponentValidator.UploadAreaValidator((JTextComponent)new JTextField(), this.areaValidatorFeedback);
    private final transient UploadDialogModel model;
    private final transient JLabel uploadCommentFeedback = new JLabel();
    private final transient UploadTextComponentValidator.UploadCommentValidator uploadCommentValidator = new UploadTextComponentValidator.UploadCommentValidator((JTextComponent)this.hcbUploadComment.getEditorComponent(), this.uploadCommentFeedback);
    private final transient JLabel hcbUploadSourceFeedback = new JLabel();
    private final transient UploadTextComponentValidator.UploadSourceValidator uploadSourceValidator = new UploadTextComponentValidator.UploadSourceValidator((JTextComponent)this.hcbUploadSource.getEditorComponent(), this.hcbUploadSourceFeedback);
    private boolean locked;

    public BasicUploadSettingsPanel(UploadDialogModel model) {
        this.model = model;
        this.model.addTableModelListener(this);
        this.build();
    }

    protected JPanel buildUploadCommentPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(I18n.tr("Provide a brief comment for the changes you are uploading:", new Object[0])));
        this.hcbUploadComment.setToolTipText(I18n.tr("Enter an upload comment", new Object[0]));
        this.hcbUploadComment.setMaxTextLength(255);
        JTextField editor = this.hcbUploadComment.getEditorComponent();
        editor.getDocument().putProperty("tag", "comment");
        editor.addKeyListener(this);
        editor.addFocusListener(this);
        editor.addActionListener(this);
        pnl.add((Component)this.hcbUploadComment, GBC.eol().fill(2));
        pnl.add((Component)this.uploadCommentFeedback, GBC.eol().insets(0, 3, 0, 0).fill(2));
        return pnl;
    }

    protected JPanel buildUploadSourcePanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(I18n.tr("Specify the data source for the changes", new Object[0])));
        JMultilineLabel obtainSourceOnce = new JMultilineLabel("<html>(<a href=\"urn:changeset-source\">" + I18n.tr("just once", new Object[0]) + "</a>)</html>");
        obtainSourceOnce.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                this.saveEdits();
                this.model.put("source", this.getSourceFromLayer());
            }
        });
        this.obtainSourceAutomatically.setSelected(Config.getPref().getBoolean("upload.source.obtainautomatically", false));
        this.obtainSourceAutomatically.addActionListener(e -> {
            if (this.obtainSourceAutomatically.isSelected()) {
                this.model.put("source", this.getSourceFromLayer());
            }
            obtainSourceOnce.setVisible(!this.obtainSourceAutomatically.isSelected());
        });
        JPanel obtainSource = new JPanel(new GridBagLayout());
        obtainSource.add((Component)this.obtainSourceAutomatically, GBC.std().anchor(17));
        obtainSource.add((Component)obtainSourceOnce, GBC.std().anchor(17));
        obtainSource.add((Component)new JLabel(), GBC.eol().fill(2));
        if (Config.getPref().getBoolean("upload.show.automatic.source", true)) {
            pnl.add((Component)obtainSource, GBC.eol().insets(0, 0, 10, 3).fill(2));
        }
        this.hcbUploadSource.setToolTipText(I18n.tr("Enter a source", new Object[0]));
        this.hcbUploadSource.setMaxTextLength(255);
        JTextField editor = this.hcbUploadSource.getEditorComponent();
        editor.getDocument().putProperty("tag", "source");
        editor.addKeyListener(this);
        editor.addFocusListener(this);
        editor.addActionListener(this);
        pnl.add((Component)this.hcbUploadSource, GBC.eol().fill(2));
        pnl.add((Component)this.hcbUploadSourceFeedback, GBC.eol().insets(0, 3, 0, 0).fill(2));
        return pnl;
    }

    public void initLifeCycle(Map<String, String> map) {
        Optional.ofNullable(BasicUploadSettingsPanel.getLastChangesetTagFromHistory(COMMENT_HISTORY_KEY, new ArrayList<String>())).ifPresent(x -> map.put("comment", (String)x));
        Optional.ofNullable(BasicUploadSettingsPanel.getLastChangesetTagFromHistory(SOURCE_HISTORY_KEY, BasicUploadSettingsPanel.getDefaultSources())).ifPresent(x -> map.put("source", (String)x));
        if (this.obtainSourceAutomatically.isSelected()) {
            map.put("source", this.getSourceFromLayer());
        }
        this.hcbUploadComment.getModel().prefs().load(COMMENT_HISTORY_KEY);
        this.hcbUploadComment.discardAllUndoableEdits();
        this.hcbUploadSource.getModel().prefs().load(SOURCE_HISTORY_KEY, BasicUploadSettingsPanel.getDefaultSources());
        this.hcbUploadSource.discardAllUndoableEdits();
    }

    private String get(String key) {
        TagModel tm = this.model.get(key);
        return tm == null ? "" : tm.getValue();
    }

    public static String getLastChangesetTagFromHistory(String historyKey, List<String> def) {
        List<String> history = Config.getPref().getList(historyKey, def);
        long age = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - BasicUploadSettingsPanel.getHistoryLastUsedKey();
        if (age < BasicUploadSettingsPanel.getHistoryMaxAgeKey() && !history.isEmpty()) {
            return (String)history.iterator().next();
        }
        return null;
    }

    private String getSourceFromLayer() {
        String source = MainApplication.getMap().mapView.getLayerInformationForSourceTag();
        return Utils.shortenString(source, 255);
    }

    public static List<String> getDefaultSources() {
        return Arrays.asList("knowledge", "survey", "Bing");
    }

    protected List<UploadTextComponentValidator> getUploadTextValidators() {
        return Arrays.asList(this.areaValidator, this.uploadCommentValidator, this.uploadSourceValidator);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GBC gbc = GBC.eol().insets(0, 0, 0, 20).fill(2);
        this.add((Component)this.buildUploadCommentPanel(), gbc);
        this.add((Component)this.buildUploadSourcePanel(), gbc);
        this.add((Component)this.pnlUploadParameterSummary, gbc);
        if (Config.getPref().getBoolean("upload.show.review.request", true)) {
            this.add((Component)this.cbRequestReview, gbc);
            this.cbRequestReview.addItemListener(this);
        }
        this.add((Component)this.areaValidatorFeedback, gbc);
        this.add((Component)new JPanel(), GBC.std().fill(1));
    }

    public void rememberUserInput() {
        if (BasicUploadSettingsPanel.getHistoryMaxAgeKey() > 0L) {
            this.hcbUploadComment.addCurrentItemToHistory();
            this.hcbUploadComment.getModel().prefs().save(COMMENT_HISTORY_KEY);
            Config.getPref().putLong(COMMENT_LAST_USED_KEY, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        }
        this.hcbUploadSource.addCurrentItemToHistory();
        this.hcbUploadSource.getModel().prefs().save(SOURCE_HISTORY_KEY);
        Config.getPref().putBoolean("upload.source.obtainautomatically", this.obtainSourceAutomatically.isSelected());
    }

    public void startUserInput() {
        this.hcbUploadComment.getEditorComponent().requestFocusInWindow();
        this.uploadCommentValidator.validate();
        this.uploadSourceValidator.validate();
    }

    public void initEditingOfUploadComment() {
        this.hcbUploadComment.getEditor().selectAll();
        this.hcbUploadComment.requestFocusInWindow();
    }

    public void initEditingOfUploadSource() {
        this.hcbUploadSource.getEditor().selectAll();
        this.hcbUploadSource.requestFocusInWindow();
    }

    void setUploadedPrimitives(List<OsmPrimitive> primitives) {
        this.areaValidator.computeArea(primitives);
    }

    public UploadParameterSummaryPanel getUploadParameterSummaryPanel() {
        return this.pnlUploadParameterSummary;
    }

    static long getHistoryMaxAgeKey() {
        return Config.getPref().getLong(COMMENT_MAX_AGE_KEY, TimeUnit.HOURS.toSeconds(4L));
    }

    static long getHistoryLastUsedKey() {
        return Config.getPref().getLong(COMMENT_LAST_USED_KEY, 0L);
    }

    private void updateHistory(JTextField text) {
        String tag = (String)text.getDocument().getProperty("tag");
        if ("comment".equals(tag)) {
            this.hcbUploadComment.addCurrentItemToHistory();
        } else if ("source".equals(tag)) {
            this.hcbUploadSource.addCurrentItemToHistory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModel(JTextField text) {
        if (!this.locked) {
            this.locked = true;
            try {
                String tag = (String)text.getDocument().getProperty("tag");
                String value = text.getText();
                this.model.put(tag, value.isEmpty() ? null : value);
            }
            finally {
                this.locked = false;
            }
        }
    }

    public void saveEdits() {
        this.updateModel(this.hcbUploadComment.getEditorComponent());
        this.hcbUploadComment.addCurrentItemToHistory();
        this.updateModel(this.hcbUploadSource.getEditorComponent());
        this.hcbUploadSource.addCurrentItemToHistory();
    }

    private UploadDialog getDialog() {
        Container d = this.getRootPane();
        while ((d = d.getParent()) != null) {
            if (!(d instanceof UploadDialog)) continue;
            return (UploadDialog)d;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setFocusToUploadButton();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object c = e.getSource();
        if (c instanceof JTextField) {
            this.updateModel((JTextField)c);
            this.updateHistory((JTextField)c);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.locked) {
            this.locked = true;
            try {
                this.model.put("review_requested", e.getStateChange() == 1 ? "yes" : null);
            }
            finally {
                this.locked = false;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.locked) {
            this.locked = true;
            try {
                this.hcbUploadComment.setText(this.get("comment"));
                this.hcbUploadSource.setText(this.get("source"));
                this.cbRequestReview.setSelected(this.get("review_requested").equals("yes"));
            }
            finally {
                this.locked = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.setFocusToUploadButton();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void setFocusToUploadButton() {
        Optional.ofNullable(this.getDialog()).ifPresent(UploadDialog::setFocusToUploadButton);
    }
}

