/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.Rendering;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractMapRenderer
implements Rendering {
    protected final Graphics2D g;
    protected final NavigatableComponent nc;
    protected final MapViewState mapState;
    protected boolean isInactiveMode;
    protected Color backgroundColor;
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color relationSelectedColor;
    protected Color nodeColor;
    protected Color highlightColor;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;
    protected boolean doSlowOperations = true;

    protected AbstractMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) {
        CheckParameterUtil.ensureParameterNotNull(g);
        CheckParameterUtil.ensureParameterNotNull(nc);
        this.g = g;
        this.nc = nc;
        this.mapState = nc.getState();
        this.isInactiveMode = isInactiveMode;
    }

    public abstract void drawNode(INode var1, Color var2, int var3, boolean var4);

    protected void drawOrderNumber(MapViewState.MapViewPoint p1, MapViewState.MapViewPoint p2, int orderNumber, Color clr) {
        if (this.isSegmentVisible(p1, p2) && AbstractMapRenderer.isLargeSegment(p1, p2, this.segmentNumberSpace)) {
            String on = Integer.toString(orderNumber);
            int strlen = on.length();
            double centerX = (p1.getInViewX() + p2.getInViewX()) / 2.0;
            double centerY = (p1.getInViewY() + p2.getInViewY()) / 2.0;
            double x = centerX - (double)(4 * strlen);
            double y = centerY + 4.0;
            if (this.virtualNodeSize != 0 && AbstractMapRenderer.isLargeSegment(p1, p2, this.virtualNodeSpace)) {
                y = centerY - (double)this.virtualNodeSize - 3.0;
            }
            this.g.setColor(this.backgroundColor);
            this.g.fill(new Rectangle2D.Double(x - 1.0, y - 12.0, (double)(8 * strlen) + 1.0, 14.0));
            this.g.setColor(clr);
            this.g.drawString(on, (int)x, (int)y);
        }
    }

    public void drawVirtualNodes(OsmData<?, ?, ?, ?> data, BBox bbox) {
        if (this.virtualNodeSize == 0 || data == null || bbox == null || data.isLocked()) {
            return;
        }
        GeneralPath path = new GeneralPath();
        for (IWay osm : data.searchWays(bbox)) {
            if (!osm.isUsable() || osm.isDisabledAndHidden() || osm.isDisabled()) continue;
            this.visitVirtual(path, osm);
        }
        this.g.setColor(this.nodeColor);
        this.g.draw(path);
        try {
            path = new GeneralPath();
            for (WaySegment wseg : data.getHighlightedVirtualNodes()) {
                if (!((Way)wseg.getWay()).isUsable() || ((Way)wseg.getWay()).isDisabled()) continue;
                Way tmpWay = wseg.toWay();
                this.visitVirtual(path, tmpWay);
                tmpWay.setNodes((List<Node>)null);
            }
            this.g.setColor(this.highlightColor);
            this.g.draw(path);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logging.trace(e);
        }
    }

    public void getColors() {
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
    }

    protected void getSettings(boolean virtual) {
        this.virtualNodeSize = virtual ? Config.getPref().getInt("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Config.getPref().getInt("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Config.getPref().getInt("mappaint.segmentnumber.space", 40);
        this.getColors();
    }

    public static boolean isLargeSegment(MapViewState.MapViewPoint p1, MapViewState.MapViewPoint p2, int space) {
        return p1.oneNormInView(p2) > (double)space;
    }

    protected boolean isSegmentVisible(MapViewState.MapViewPoint p1, MapViewState.MapViewPoint p2) {
        MapViewState.MapViewRectangle view = this.mapState.getViewArea();
        return (p1.getOutsideRectangleFlags(view) & p2.getOutsideRectangleFlags(view)) == 0;
    }

    public void visitVirtual(Path2D path, IWay<?> w) {
        Iterator<?> it = w.getNodes().iterator();
        MapViewState.MapViewPoint lastP = null;
        while (it.hasNext()) {
            INode n = (INode)it.next();
            if (!n.isLatLonKnown()) continue;
            MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
            if (lastP != null && this.isSegmentVisible(lastP, p) && AbstractMapRenderer.isLargeSegment(lastP, p, this.virtualNodeSpace)) {
                double x = (p.getInViewX() + lastP.getInViewX()) / 2.0;
                double y = (p.getInViewY() + lastP.getInViewY()) / 2.0;
                path.moveTo(x - (double)this.virtualNodeSize, y);
                path.lineTo(x + (double)this.virtualNodeSize, y);
                path.moveTo(x, y - (double)this.virtualNodeSize);
                path.lineTo(x, y + (double)this.virtualNodeSize);
            }
            lastP = p;
        }
    }

    public final void enableSlowOperations(boolean enable) {
        this.doSlowOperations = enable;
    }
}

