/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;

public final class TagTableModel
extends AbstractTableModel {
    private List<String> keys;
    private final PointInTimeType pointInTimeType;
    private final HistoryBrowserModel model;

    public TagTableModel(HistoryBrowserModel historyModel, PointInTimeType type) {
        this.model = historyModel;
        this.pointInTimeType = type;
        this.initKeyList();
    }

    void initKeyList() {
        this.keys = new ArrayList<String>(this.model.getKeySet());
        Collections.sort(this.keys);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getKeyAt(row);
    }

    public String getKeyAt(int row) {
        return this.keys.get(row);
    }

    public boolean hasTag(String key) {
        HistoryOsmPrimitive primitive = this.model.getPointInTime(this.pointInTimeType);
        return primitive != null && primitive.hasKey(key);
    }

    public String getValue(String key) {
        HistoryOsmPrimitive primitive = this.model.getPointInTime(this.pointInTimeType);
        if (primitive == null) {
            return null;
        }
        return primitive.get(key);
    }

    public HistoryOsmPrimitive getWhichChangedTag(String key) {
        HistoryOsmPrimitive primitive = this.model.getPointInTime(this.pointInTimeType);
        if (primitive == null) {
            return null;
        }
        return this.model.getHistory().getWhichChangedTag(primitive, key, this.model.isLatest(primitive));
    }

    public String getVersionString(HistoryOsmPrimitive primitive) {
        return this.model.isLatest(primitive) ? "*" : "v" + primitive.getVersion();
    }

    public Color getVersionColor(HistoryOsmPrimitive primitive) {
        return this.model.getVersionColor(primitive);
    }

    public boolean oppositeHasTag(String key) {
        HistoryOsmPrimitive primitive = this.model.getPointInTime(this.pointInTimeType.opposite());
        return primitive != null && primitive.hasKey(key);
    }

    public String getOppositeValue(String key) {
        HistoryOsmPrimitive primitive = this.model.getPointInTime(this.pointInTimeType.opposite());
        if (primitive == null) {
            return null;
        }
        return primitive.get(key);
    }

    public boolean hasSameValueAsOpposite(String key) {
        String value = this.getValue(key);
        String oppositeValue = this.getOppositeValue(key);
        return value != null && value.equals(oppositeValue);
    }

    public PointInTimeType getPointInTimeType() {
        return this.pointInTimeType;
    }

    public boolean isCurrentPointInTime() {
        return this.pointInTimeType == PointInTimeType.CURRENT_POINT_IN_TIME;
    }

    public boolean isReferencePointInTime() {
        return this.pointInTimeType == PointInTimeType.REFERENCE_POINT_IN_TIME;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    TwoColumnDiff.Item.DiffItemType getDiffItemType(String key, boolean isValue) {
        if (!this.hasTag(key) && this.isCurrentPointInTime() || !this.oppositeHasTag(key) && this.isReferencePointInTime()) {
            return TwoColumnDiff.Item.DiffItemType.DELETED;
        }
        if (!this.oppositeHasTag(key) && this.isCurrentPointInTime() || !this.hasTag(key) && this.isReferencePointInTime()) {
            return TwoColumnDiff.Item.DiffItemType.INSERTED;
        }
        if (isValue && this.hasTag(key) && this.oppositeHasTag(key) && !this.hasSameValueAsOpposite(key)) {
            return TwoColumnDiff.Item.DiffItemType.CHANGED;
        }
        return TwoColumnDiff.Item.DiffItemType.EMPTY;
    }
}

