/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelationSettings;
import org.openstreetmap.josm.data.gpx.GpxImageDirectionPositionSettings;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class GpxImageCorrelation {
    private GpxImageCorrelation() {
    }

    public static int matchGpxTrack(List<? extends GpxImageEntry> images, GpxData selectedGpx, GpxImageCorrelationSettings settings) {
        int trkTime;
        int trkDist;
        int trkTagTime;
        int segTime;
        int segDist;
        int segTagTime;
        boolean trkInt;
        boolean trkTag;
        boolean segInt;
        boolean segTag;
        int ret = 0;
        if (Logging.isDebugEnabled()) {
            Logging.debug("Correlating {0} images to {1} GPX track segments using {2}", images.size(), selectedGpx.getTrackSegsCount(), settings);
        }
        if (settings.isForceTags()) {
            segTag = true;
            segInt = true;
            trkTag = true;
            trkInt = true;
            segTagTime = Integer.MAX_VALUE;
            segDist = Integer.MAX_VALUE;
            segTime = Integer.MAX_VALUE;
            trkTagTime = Integer.MAX_VALUE;
            trkDist = Integer.MAX_VALUE;
            trkTime = Integer.MAX_VALUE;
        } else {
            trkInt = Config.getPref().getBoolean("geoimage.trk.int", false);
            trkTime = Config.getPref().getBoolean("geoimage.trk.int.time", false) ? Config.getPref().getInt("geoimage.trk.int.time.val", 60) : Integer.MAX_VALUE;
            trkDist = Config.getPref().getBoolean("geoimage.trk.int.dist", false) ? Config.getPref().getInt("geoimage.trk.int.dist.val", 50) : Integer.MAX_VALUE;
            trkTag = Config.getPref().getBoolean("geoimage.trk.tag", true);
            trkTagTime = Config.getPref().getBoolean("geoimage.trk.tag.time", true) ? Config.getPref().getInt("geoimage.trk.tag.time.val", 2) : Integer.MAX_VALUE;
            segInt = Config.getPref().getBoolean("geoimage.seg.int", true);
            segTime = Config.getPref().getBoolean("geoimage.seg.int.time", true) ? Config.getPref().getInt("geoimage.seg.int.time.val", 60) : Integer.MAX_VALUE;
            segDist = Config.getPref().getBoolean("geoimage.seg.int.dist", true) ? Config.getPref().getInt("geoimage.seg.int.dist.val", 50) : Integer.MAX_VALUE;
            segTag = Config.getPref().getBoolean("geoimage.seg.tag", true);
            segTagTime = Config.getPref().getBoolean("geoimage.seg.tag.time", true) ? Config.getPref().getInt("geoimage.seg.tag.time.val", 2) : Integer.MAX_VALUE;
        }
        GpxImageDirectionPositionSettings dirpos = settings.getDirectionPositionSettings();
        long offset = settings.getOffset();
        boolean isFirst = true;
        long prevWpTime = 0L;
        WayPoint prevWp = null;
        for (List<List<WayPoint>> segs : GpxImageCorrelation.loadTracks(selectedGpx.getTracks())) {
            boolean firstSegment = true;
            block1: for (List<WayPoint> wps : segs) {
                for (int i = 0; i < wps.size(); ++i) {
                    WayPoint curWp = wps.get(i);
                    if (!curWp.hasDate()) {
                        if (i <= 0 || !wps.get(i - 1).hasDate()) continue;
                        long prevWpTimeNoOffset = wps.get(i - 1).getTimeInMillis();
                        double totalDist = 0.0;
                        ArrayList<Pair<Double, WayPoint>> nextWps = new ArrayList<Pair<Double, WayPoint>>();
                        for (int j = i; j < wps.size(); ++j) {
                            nextWps.add(new Pair<Double, WayPoint>(totalDist += wps.get(j - 1).getCoor().greatCircleDistance(wps.get(j).getCoor()), wps.get(j)));
                            if (!wps.get(j).hasDate()) continue;
                            long timeDiff = wps.get(j).getTimeInMillis() - prevWpTimeNoOffset;
                            for (Pair pair : nextWps) {
                                ((WayPoint)pair.b).setTimeInMillis((long)((double)prevWpTimeNoOffset + (double)timeDiff * ((Double)pair.a / totalDist)));
                            }
                            break;
                        }
                        if (!curWp.hasDate()) continue block1;
                    }
                    long curWpTime = curWp.getTimeInMillis() + offset;
                    boolean interpolate = true;
                    int tagTime = 0;
                    if (i == 0) {
                        if (firstSegment) {
                            firstSegment = false;
                            if (!trkInt || isFirst || prevWp == null || Math.abs(curWpTime - prevWpTime) > TimeUnit.MINUTES.toMillis(trkTime) || prevWp.getCoor().greatCircleDistance(curWp.getCoor()) > (double)trkDist) {
                                isFirst = false;
                                interpolate = false;
                                if (trkTag) {
                                    tagTime = trkTagTime;
                                }
                            }
                        } else if (!segInt || prevWp == null || Math.abs(curWpTime - prevWpTime) > TimeUnit.MINUTES.toMillis(segTime) || prevWp.getCoor().greatCircleDistance(curWp.getCoor()) > (double)segDist) {
                            interpolate = false;
                            if (segTag) {
                                tagTime = segTagTime;
                            }
                        }
                    }
                    ret += GpxImageCorrelation.matchPoints(images, prevWp, prevWpTime, curWp, curWpTime, offset, interpolate, tagTime, false, dirpos);
                    prevWp = curWp;
                    prevWpTime = curWpTime;
                }
            }
        }
        if (trkTag && prevWp != null) {
            ret += GpxImageCorrelation.matchPoints(images, prevWp, prevWpTime, prevWp, prevWpTime, offset, false, trkTagTime, true, dirpos);
        }
        return ret;
    }

    static List<List<List<WayPoint>>> loadTracks(Collection<IGpxTrack> tracks) {
        ArrayList<List<List<WayPoint>>> trks = new ArrayList<List<List<WayPoint>>>();
        for (IGpxTrack trk : tracks) {
            ArrayList segs = new ArrayList();
            for (IGpxTrackSegment seg : trk.getSegments()) {
                int wp;
                ArrayList<WayPoint> wps = new ArrayList<WayPoint>(seg.getWayPoints());
                if (wps.isEmpty()) continue;
                for (wp = 0; wp < wps.size() && !((WayPoint)wps.get(wp)).hasDate(); ++wp) {
                }
                if (wp == 0) {
                    segs.add(wps);
                    continue;
                }
                if (wp >= wps.size()) continue;
                segs.add(wps.subList(wp, wps.size()));
            }
            if (segs.isEmpty()) continue;
            segs.sort((o1, o2) -> {
                if (o1.isEmpty() || o2.isEmpty()) {
                    return 0;
                }
                return ((WayPoint)o1.get(0)).compareTo((WayPoint)o2.get(0));
            });
            trks.add(segs);
        }
        trks.sort((o1, o2) -> {
            if (o1.isEmpty() || ((List)o1.get(0)).isEmpty() || o2.isEmpty() || ((List)o2.get(0)).isEmpty()) {
                return 0;
            }
            return ((WayPoint)((List)o1.get(0)).get(0)).compareTo((WayPoint)((List)o2.get(0)).get(0));
        });
        return trks;
    }

    static Double getElevation(WayPoint wp) {
        String value;
        if (wp != null && (value = wp.getString("ele")) != null && !value.isEmpty()) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    private static int matchPoints(List<? extends GpxImageEntry> images, WayPoint prevWp, long prevWpTime, WayPoint curWp, long curWpTime, long offset, boolean interpolate, int tagTime, boolean isLast, GpxImageDirectionPositionSettings dirpos) {
        int ret;
        block15: {
            Double curElevation;
            Double prevElevation;
            Double speed;
            int i;
            block16: {
                ret = 0;
                i = isLast ? images.size() - 1 : GpxImageCorrelation.getLastIndexOfListBefore(images, curWpTime);
                if (i < 0) {
                    return 0;
                }
                speed = null;
                prevElevation = null;
                if (prevWp != null && interpolate) {
                    double distance = prevWp.getCoor().greatCircleDistance(curWp.getCoor());
                    if (curWpTime > prevWpTime) {
                        speed = 3600.0 * distance / (double)(curWpTime - prevWpTime);
                    }
                    prevElevation = GpxImageCorrelation.getElevation(prevWp);
                }
                curElevation = GpxImageCorrelation.getElevation(curWp);
                if (interpolate && !isLast) break block16;
                long half = Math.abs(curWpTime - prevWpTime) / 2L;
                while (i >= 0) {
                    GpxImageEntry curImg = images.get(i);
                    GpxImageEntry curTmp = curImg.getTmp();
                    long time = curImg.getExifInstant().toEpochMilli();
                    if ((isLast || time <= curWpTime) && time >= prevWpTime) {
                        long tagms = TimeUnit.MINUTES.toMillis(tagTime);
                        if (!(curTmp.hasNewGpsData() || Math.abs(time - curWpTime) > tagms && Math.abs(prevWpTime - time) > tagms)) {
                            if (prevWp != null && time < curWpTime - half) {
                                curTmp.setPos(prevWp.getCoor());
                            } else {
                                curTmp.setPos(curWp.getCoor());
                            }
                            curTmp.setGpsTime(curImg.getExifInstant().minusMillis(offset));
                            curTmp.flagNewGpsData();
                            curImg.tmpUpdated();
                            ++ret;
                        }
                        --i;
                        continue;
                    }
                    break block15;
                }
                break block15;
            }
            if (prevWp == null) break block15;
            while (i >= 0) {
                GpxImageEntry curImg = images.get(i);
                GpxImageEntry curTmp = curImg.getTmp();
                long imgTime = curImg.getExifInstant().toEpochMilli();
                if (imgTime >= prevWpTime) {
                    if (!curTmp.hasNewGpsData()) {
                        double timeDiff = (double)(imgTime - prevWpTime) / (double)Math.abs(curWpTime - prevWpTime);
                        boolean shiftXY = dirpos.getShiftImageX() != 0.0 || dirpos.getShiftImageY() != 0.0;
                        LatLon prevCoor = prevWp.getCoor();
                        LatLon curCoor = curWp.getCoor();
                        LatLon position = prevCoor.interpolate(curCoor, timeDiff);
                        if (shiftXY || dirpos.isSetImageDirection()) {
                            double direction = prevCoor.bearing(curCoor);
                            if (dirpos.isSetImageDirection()) {
                                curTmp.setExifImgDir((Utils.toDegrees(direction) + dirpos.getImageDirectionAngleOffset()) % 360.0);
                                direction = Utils.toRadians(curTmp.getExifImgDir());
                            }
                            if (shiftXY) {
                                Projection proj = ProjectionRegistry.getProjection();
                                double offsetX = dirpos.getShiftImageX();
                                double offsetY = dirpos.getShiftImageY();
                                double r = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
                                double orientation = (direction + LatLon.ZERO.bearing(new LatLon(offsetX, offsetY))) % (Math.PI * 2);
                                position = proj.eastNorth2latlon(proj.latlon2eastNorth(position).add(r * Math.sin(orientation), r * Math.cos(orientation)));
                            }
                        }
                        curTmp.setPos(position);
                        curTmp.setSpeed(speed);
                        if (curElevation != null && prevElevation != null) {
                            curTmp.setElevation(prevElevation + (curElevation - prevElevation) * timeDiff + dirpos.getElevationShift());
                        }
                        curTmp.setGpsTime(curImg.getExifInstant().minusMillis(offset));
                        curTmp.flagNewGpsData();
                        curImg.tmpUpdated();
                        ++ret;
                    }
                    --i;
                    continue;
                }
                break;
            }
        }
        return ret;
    }

    private static int getLastIndexOfListBefore(List<? extends GpxImageEntry> images, long searchedTime) {
        int lstSize = images.size();
        if (lstSize == 0 || searchedTime < images.get(0).getExifInstant().toEpochMilli()) {
            return -1;
        }
        if (searchedTime > images.get(lstSize - 1).getExifInstant().toEpochMilli()) {
            return lstSize - 1;
        }
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            int curIndex = (endIndex + startIndex) / 2;
            if (searchedTime > images.get(curIndex).getExifInstant().toEpochMilli()) {
                startIndex = curIndex;
                continue;
            }
            endIndex = curIndex;
        }
        if (searchedTime < images.get(endIndex).getExifInstant().toEpochMilli()) {
            return startIndex;
        }
        while (endIndex < lstSize - 1 && images.get(endIndex).getExifInstant().toEpochMilli() == images.get(endIndex + 1).getExifInstant().toEpochMilli()) {
            ++endIndex;
        }
        return endIndex;
    }
}

