/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.imagery.TileAnchor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ImageWarp;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class ReprojectionTile
extends Tile {
    protected TileAnchor anchor;
    private double nativeScale;
    protected boolean maxZoomReached;

    public ReprojectionTile(TileSource source, int xtile, int ytile, int zoom) {
        super(source, xtile, ytile, zoom);
    }

    public TileAnchor getAnchor() {
        return this.anchor;
    }

    public double getNativeScale() {
        return this.nativeScale;
    }

    public synchronized boolean needsUpdate(double currentScale) {
        if (Utils.equalsEpsilon(this.nativeScale, currentScale)) {
            return false;
        }
        return !this.maxZoomReached || currentScale >= this.nativeScale;
    }

    @Override
    public void setImage(BufferedImage image) {
        if (image == null) {
            this.reset();
        } else {
            this.transform(image);
        }
    }

    public synchronized void invalidate() {
        this.loaded = false;
        this.loading = false;
        this.error = false;
        this.error_message = null;
    }

    private synchronized void reset() {
        this.image = null;
        this.anchor = null;
        this.maxZoomReached = false;
    }

    private EastNorth tileToEastNorth(int x, int y, int z) {
        return CoordinateConversion.projToEn(this.source.tileXYtoProjected(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transform(BufferedImage imageIn) {
        ImageWarp.Interpolation interpolation;
        if (!MainApplication.isDisplayingMapView()) {
            this.reset();
            return;
        }
        double scaleMapView = MainApplication.getMap().mapView.getScale();
        switch (Config.getPref().get("imagery.warp.pixel-interpolation", "bilinear")) {
            case "nearest_neighbor": {
                interpolation = ImageWarp.Interpolation.NEAREST_NEIGHBOR;
                break;
            }
            default: {
                interpolation = ImageWarp.Interpolation.BILINEAR;
            }
        }
        Projection projCurrent = ProjectionRegistry.getProjection();
        Projection projServer = Projections.getProjectionByCode(this.source.getServerCRS());
        EastNorth en00Server = this.tileToEastNorth(this.xtile, this.ytile, this.zoom);
        EastNorth en11Server = this.tileToEastNorth(this.xtile + 1, this.ytile + 1, this.zoom);
        ProjectionBounds pbServer = new ProjectionBounds(en00Server);
        pbServer.extend(en11Server);
        ProjectionBounds pbTarget = projCurrent.getEastNorthBoundsBox(pbServer, projServer);
        double margin = 2.0;
        Dimension dim = ReprojectionTile.getDimension(ReprojectionTile.pbMarginAndAlign(pbTarget, scaleMapView, margin), scaleMapView);
        Integer scaleFix = this.limitScale(this.source.getTileSize(), Math.sqrt(dim.getWidth() * dim.getHeight()));
        double scale = scaleFix == null ? scaleMapView : scaleMapView * (double)scaleFix.intValue();
        ProjectionBounds pbTargetAligned = ReprojectionTile.pbMarginAndAlign(pbTarget, scale, margin);
        ImageWarp.PointTransform pointTransform = pt -> {
            EastNorth target = new EastNorth(pbTargetAligned.minEast + pt.getX() * scale, pbTargetAligned.maxNorth - pt.getY() * scale);
            EastNorth sourceEN = projServer.latlon2eastNorth(projCurrent.eastNorth2latlon(target));
            double x = (double)this.source.getTileSize() * (sourceEN.east() - pbServer.minEast) / (pbServer.maxEast - pbServer.minEast);
            double y = (double)this.source.getTileSize() * (pbServer.maxNorth - sourceEN.north()) / (pbServer.maxNorth - pbServer.minNorth);
            return new Point2D.Double(x, y);
        };
        EastNorth en00Current = projCurrent.latlon2eastNorth(projServer.eastNorth2latlon(en00Server));
        EastNorth en11Current = projCurrent.latlon2eastNorth(projServer.eastNorth2latlon(en11Server));
        Point2D.Double p00Img = new Point2D.Double((en00Current.east() - pbTargetAligned.minEast) / scale, (pbTargetAligned.maxNorth - en00Current.north()) / scale);
        Point2D.Double p11Img = new Point2D.Double((en11Current.east() - pbTargetAligned.minEast) / scale, (pbTargetAligned.maxNorth - en11Current.north()) / scale);
        int stride = Config.getPref().getInt("imagery.warp.projection-interpolation.stride", 7);
        ImageWarp.PointTransform transform = stride > 0 ? new ImageWarp.GridTransform(pointTransform, stride) : pointTransform;
        Dimension targetDim = ReprojectionTile.getDimension(pbTargetAligned, scale);
        try {
            BufferedImage imageOut = ImageWarp.warp(imageIn, targetDim, transform, interpolation);
            ReprojectionTile reprojectionTile = this;
            synchronized (reprojectionTile) {
                this.image = imageOut;
                this.anchor = new TileAnchor(p00Img, p11Img);
                this.nativeScale = scale;
                this.maxZoomReached = scaleFix != null;
            }
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw BugReport.intercept(e).put("targetDim", targetDim).put("key", this.getKey()).put("projCurrent", projCurrent).put("projServer", projServer).put("pbServer", pbServer);
        }
    }

    private static ProjectionBounds pbMarginAndAlign(ProjectionBounds box, double scale, double margin) {
        double minEast = Math.floor(box.minEast / scale - margin) * scale;
        double minNorth = -Math.floor(-(box.minNorth / scale - margin)) * scale;
        double maxEast = Math.ceil(box.maxEast / scale + margin) * scale;
        double maxNorth = -Math.ceil(-(box.maxNorth / scale + margin)) * scale;
        return new ProjectionBounds(minEast, minNorth, maxEast, maxNorth);
    }

    private static Dimension getDimension(ProjectionBounds bounds, double scale) {
        return new Dimension((int)Math.round((bounds.maxEast - bounds.minEast) / scale), (int)Math.round((bounds.maxNorth - bounds.minNorth) / scale));
    }

    protected Integer limitScale(double lenOrig, double lenNow) {
        double limit = 3.0;
        if (lenNow > 3.0 * lenOrig) {
            int n = (int)Math.ceil((Math.log(lenNow) - Math.log(3.0 * lenOrig)) / Math.log(2.0));
            int f = 1 << n;
            double lenNowFixed = lenNow / (double)f;
            if (lenNowFixed > 3.0 * lenOrig) {
                throw new AssertionError();
            }
            if (lenNowFixed <= 3.0 * lenOrig / 2.0) {
                throw new AssertionError();
            }
            return f;
        }
        if (lenNow > 3.0 * lenOrig / 2.0) {
            return 1;
        }
        return null;
    }
}

