/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static final int UNORDERED_COASTLINE = 901;
    protected static final int REVERSED_COASTLINE = 902;
    protected static final int UNCONNECTED_COASTLINE = 903;
    protected static final int WRONG_ORDER_COASTLINE = 904;
    private List<Way> coastlineWays;

    public Coastlines() {
        super(I18n.tr("Coastlines", new Object[0]), I18n.tr("This test checks that coastlines are correct.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.coastlineWays = new LinkedList<Way>();
    }

    @Override
    public void endTest() {
        this.checkConnections();
        this.checkDirection();
        this.coastlineWays = null;
        super.endTest();
    }

    private void checkConnections() {
        Area downloadedArea = null;
        for (Way w : this.coastlineWays) {
            if (downloadedArea == null) {
                downloadedArea = w.getDataSet().getDataSourceArea();
            }
            int numNodes = w.getNodesCount();
            for (int i = 0; i < numNodes; ++i) {
                Node n = w.getNode(i);
                List<OsmPrimitive> refs = n.getReferrers();
                HashSet<Way> connectedWays = new HashSet<Way>();
                for (OsmPrimitive p : refs) {
                    if (p == w || !Coastlines.isCoastline(p)) continue;
                    connectedWays.add((Way)p);
                }
                if (i == 0) {
                    if (connectedWays.isEmpty() && n != w.lastNode() && n.getCoor().isIn(downloadedArea)) {
                        this.addError(903, w, null, n);
                    }
                    if (connectedWays.size() == 1 && n != ((Way)connectedWays.iterator().next()).lastNode()) {
                        this.checkIfReversed(w, (Way)connectedWays.iterator().next(), n);
                    }
                    if (connectedWays.size() != 1 || !w.isClosed() || !((Way)connectedWays.iterator().next()).isClosed()) continue;
                    this.addError(901, w, connectedWays, n);
                    continue;
                }
                if (i == numNodes - 1) {
                    if (connectedWays.isEmpty() && n != w.firstNode() && n.getCoor().isIn(downloadedArea)) {
                        this.addError(903, w, null, n);
                    }
                    if (connectedWays.size() != 1 || n == ((Way)connectedWays.iterator().next()).firstNode()) continue;
                    this.checkIfReversed(w, (Way)connectedWays.iterator().next(), n);
                    continue;
                }
                if (connectedWays.isEmpty()) continue;
                this.addError(901, w, connectedWays, n);
            }
        }
    }

    private void checkDirection() {
        HashSet<Way> done = new HashSet<Way>();
        for (Way w : this.coastlineWays) {
            if (done.contains(w)) continue;
            ArrayList<Way> visited = new ArrayList<Way>();
            done.add(w);
            visited.add(w);
            ArrayList<Node> nodes = new ArrayList<Node>(w.getNodes());
            Way curr = w;
            while (nodes.get(0) != nodes.get(nodes.size() - 1)) {
                boolean foundContinuation = false;
                for (OsmPrimitive p : curr.lastNode().getReferrers()) {
                    Way other;
                    if (p == curr || !Coastlines.isCoastline(p) || done.contains(other = (Way)p) || other.firstNode() != curr.lastNode()) continue;
                    foundContinuation = true;
                    curr = other;
                    done.add(curr);
                    visited.add(curr);
                    nodes.remove(nodes.size() - 1);
                    nodes.addAll(curr.getNodes());
                    break;
                }
                if (foundContinuation) continue;
                break;
            }
            if (visited.size() <= 1 || nodes.get(0) != nodes.get(nodes.size() - 1) || !Geometry.isClockwise(nodes)) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 904).message(I18n.tr("Reversed coastline: land not on left side", new Object[0])).primitives(visited).build());
        }
    }

    private void checkIfReversed(Way w, Way other, Node n1) {
        boolean headFixedWithReverse = false;
        boolean tailFixedWithReverse = false;
        int otherCoastlineWays = 0;
        Way connectedToFirst = null;
        for (int i = 0; i < 2; ++i) {
            Node n = i == 0 ? w.firstNode() : w.lastNode();
            List<OsmPrimitive> refs = n.getReferrers();
            for (OsmPrimitive p : refs) {
                if (p == w || !Coastlines.isCoastline(p)) continue;
                Way cw = (Way)p;
                if (i == 0 && cw.firstNode() == n) {
                    headFixedWithReverse = true;
                    connectedToFirst = cw;
                    continue;
                }
                if (i == 1 && cw.lastNode() == n) {
                    if (cw == connectedToFirst) continue;
                    tailFixedWithReverse = true;
                    continue;
                }
                ++otherCoastlineWays;
            }
        }
        if (otherCoastlineWays == 0 && headFixedWithReverse && tailFixedWithReverse) {
            this.addError(902, w, null, null);
        } else {
            this.addError(901, w, Collections.singletonList(other), n1);
        }
    }

    private void addError(int errCode, Way w, Collection<Way> otherWays, Node n) {
        String msg;
        switch (errCode) {
            case 903: {
                msg = I18n.tr("Unconnected coastline", new Object[0]);
                break;
            }
            case 901: {
                msg = I18n.tr("Unordered coastline", new Object[0]);
                break;
            }
            case 902: {
                msg = I18n.tr("Reversed coastline", new Object[0]);
                break;
            }
            default: {
                msg = I18n.tr("invalid coastline", new Object[0]);
            }
        }
        HashSet<Way> primitives = new HashSet<Way>();
        primitives.add(w);
        if (otherWays != null) {
            primitives.addAll(otherWays);
        }
        for (TestError e : this.errors) {
            if (e.getCode() != errCode || errCode != 902 && !e.getHighlighted().contains(n) || e.getPrimitives().size() != primitives.size() || !e.getPrimitives().containsAll(primitives)) continue;
            return;
        }
        if (errCode != 902) {
            this.errors.add(TestError.builder(this, Severity.ERROR, errCode).message(msg).primitives(primitives).highlight(n).build());
        } else {
            this.errors.add(TestError.builder(this, Severity.ERROR, errCode).message(msg).primitives(primitives).build());
        }
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        if (Coastlines.isCoastline(way)) {
            this.coastlineWays.add(way);
        }
    }

    private static boolean isCoastline(OsmPrimitive osm) {
        return osm instanceof Way && osm.hasTag("natural", "coastline");
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> it;
        if (this.isFixable(testError) && (it = testError.getPrimitives().iterator()).hasNext()) {
            Way way = (Way)it.next();
            List<Node> nodesCopy = way.getNodes();
            Collections.reverse(nodesCopy);
            return new ChangeNodesCommand(way, nodesCopy);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == 902;
        }
        return false;
    }
}

