/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.ArrowPaintHelper;
import org.openstreetmap.josm.data.osm.visitor.paint.ComputeStyleListWorker;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.OffsetIterator;
import org.openstreetmap.josm.data.osm.visitor.paint.RenderBenchmarkCollector;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.DefaultStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.RepeatImageElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.Symbol;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CompositeList;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.HiDPISupport;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.RotationAngle;
import org.openstreetmap.josm.tools.ShapeClipper;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class StyledMapRenderer
extends AbstractMapRenderer {
    private static final ForkJoinPool THREAD_POOL = StyledMapRenderer.newForkJoinPool();
    private static final Map<Font, Boolean> IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG = new HashMap<Font, Boolean>();
    private double circum;
    private double scale;
    private MapPaintSettings paintSettings;
    private ElemStyles styles;
    private Color highlightColorTransparent;
    static final int FLAG_NORMAL = 0;
    static final int FLAG_DISABLED = 1;
    static final int FLAG_MEMBER_OF_SELECTED = 2;
    static final int FLAG_SELECTED = 4;
    static final int FLAG_OUTERMEMBER_OF_SELECTED = 8;
    private static final double PHI = Utils.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);
    private static final AbstractProperty<Boolean> PREFERENCE_LEFT_HAND_TRAFFIC = new BooleanProperty("mappaint.lefthandtraffic", false).cached();
    public static final AbstractProperty<Boolean> PREFERENCE_ANTIALIASING_USE = new BooleanProperty("mappaint.use-antialiasing", true).cached();
    public static final AbstractProperty<String> PREFERENCE_TEXT_ANTIALIASING = new StringProperty("mappaint.text-antialiasing", "default").cached();
    private static final AbstractProperty<Integer> HIGHLIGHT_LINE_WIDTH = new IntegerProperty("mappaint.highlight.width", 4).cached();
    private static final AbstractProperty<Integer> HIGHLIGHT_POINT_RADIUS = new IntegerProperty("mappaint.highlight.radius", 7).cached();
    private static final AbstractProperty<Integer> WIDER_HIGHLIGHT = new IntegerProperty("mappaint.highlight.bigger-increment", 5).cached();
    private static final AbstractProperty<Integer> HIGHLIGHT_STEP = new IntegerProperty("mappaint.highlight.step", 4).cached();
    private Collection<WaySegment> highlightWaySegments;
    private final boolean useWiderHighlight;
    private boolean useStrokes;
    private boolean showNames;
    private boolean showIcons;
    private boolean isOutlineOnly;
    private boolean leftHandTraffic;
    private Object antialiasing;
    private Supplier<RenderBenchmarkCollector> benchmarkFactory = RenderBenchmarkCollector.defaultBenchmarkSupplier();

    private static ForkJoinPool newForkJoinPool() {
        try {
            return Utils.newForkJoinPool("mappaint.StyledMapRenderer.style_creation.numberOfThreads", "styled-map-renderer-%d", 5);
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to create new ForkJoinPool", e);
            return null;
        }
    }

    public static boolean isGlyphVectorDoubleTranslationBug(Font font) {
        Boolean cached = IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.get(font);
        if (cached != null) {
            return cached;
        }
        String overridePref = Config.getPref().get("glyph-bug", "auto");
        if ("auto".equals(overridePref)) {
            int x;
            FontRenderContext frc = new FontRenderContext(null, false, false);
            GlyphVector gv = font.createGlyphVector(frc, "x");
            gv.setGlyphTransform(0, AffineTransform.getTranslateInstance(1000.0, 1000.0));
            Shape shape = gv.getGlyphOutline(0);
            if (Logging.isTraceEnabled()) {
                Logging.trace("#10446: shape: {0}", shape.getBounds());
            }
            boolean isBug = (x = shape.getBounds().x) > 1500;
            IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.put(font, isBug);
            return isBug;
        }
        boolean override = Boolean.parseBoolean(overridePref);
        IS_GLYPH_VECTOR_DOUBLE_TRANSLATION_BUG.put(font, override);
        return override;
    }

    public StyledMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) {
        super(g, nc, isInactiveMode);
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        this.useWiderHighlight = !(focusOwner instanceof AbstractButton) && focusOwner != nc;
        this.styles = MapPaintStyles.getStyles();
    }

    public void setStyles(ElemStyles styles) {
        this.styles = styles;
    }

    private void displaySegments(MapViewPath path, Path2D orientationArrows, Path2D onewayArrows, Path2D onewayArrowsCasing, Color color, BasicStroke line, BasicStroke dashes, Color dashedColor) {
        this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
        if (this.useStrokes) {
            this.g.setStroke(line);
        }
        this.g.draw(path.computeClippedLine(this.g.getStroke()));
        if (!this.isInactiveMode && this.useStrokes && dashes != null) {
            this.g.setColor(dashedColor);
            this.g.setStroke(dashes);
            this.g.draw(path.computeClippedLine(dashes));
        }
        if (orientationArrows != null) {
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : color);
            this.g.setStroke(new BasicStroke(line.getLineWidth(), line.getEndCap(), 0, line.getMiterLimit()));
            this.g.draw(orientationArrows);
        }
        if (onewayArrows != null) {
            this.g.setStroke(new BasicStroke(1.0f, line.getEndCap(), 0, line.getMiterLimit()));
            this.g.fill(onewayArrowsCasing);
            this.g.setColor(this.isInactiveMode ? this.inactiveColor : this.backgroundColor);
            this.g.fill(onewayArrows);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    protected void drawArea(MapViewPath area, Color color, MapImage fillImage, Float extent, MapViewPath pfClip, boolean disabled) {
        if (!this.isOutlineOnly && color.getAlpha() != 0) {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (fillImage == null) {
                if (this.isInactiveMode) {
                    this.g.setComposite(AlphaComposite.getInstance(3, 0.33f));
                }
                this.g.setColor(color);
                this.computeFill(area, extent, pfClip, 4.0f);
            } else {
                Image img = HiDPISupport.getBaseImage(fillImage.getImage(disabled));
                if (img != null) {
                    this.g.setPaint(new TexturePaint((BufferedImage)img, new Rectangle(0, 0, fillImage.getWidth(), fillImage.getHeight())));
                } else {
                    Logging.warn("Unable to get image from " + fillImage);
                }
                float alpha = fillImage.getAlphaFloat();
                if (!Utils.equalsEpsilon(alpha, 1.0)) {
                    this.g.setComposite(AlphaComposite.getInstance(3, alpha));
                }
                this.computeFill(area, extent, pfClip, 10.0f);
                this.g.setPaintMode();
            }
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        }
    }

    private void computeFill(Shape shape, Float extent, MapViewPath pfClip, float mitterLimit) {
        if (extent == null) {
            this.g.fill(shape);
        } else {
            Shape oldClip = this.g.getClip();
            Shape clip = shape;
            if (pfClip != null) {
                clip = pfClip;
            }
            this.g.clip(clip);
            this.g.setStroke(new BasicStroke(2.0f * extent.floatValue(), 0, 0, mitterLimit));
            this.g.draw(shape);
            this.g.setClip(oldClip);
            this.g.setStroke(new BasicStroke());
        }
    }

    public void drawArea(Relation r, Color color, MapImage fillImage, Float extent, Float extentThreshold, boolean disabled) {
        Multipolygon multipolygon = MultipolygonCache.getInstance().get(r);
        if (!r.isDisabled() && !multipolygon.getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                if (!this.isAreaVisible(pd.get())) continue;
                MapViewPath p = this.shapeEastNorthToMapView(pd.get());
                MapViewPath pfClip = null;
                if (extent != null) {
                    if (!this.usePartialFill(pd.getAreaAndPerimeter(null), extent.floatValue(), extentThreshold)) {
                        extent = null;
                    } else if (!pd.isClosed()) {
                        pfClip = this.shapeEastNorthToMapView(StyledMapRenderer.getPFClip(pd, (double)extent.floatValue() * this.scale));
                    }
                }
                this.drawArea(p, pd.isSelected() ? this.paintSettings.getRelationSelectedColor(color.getAlpha()) : color, fillImage, extent, pfClip, disabled);
            }
        }
    }

    private MapViewPath shapeEastNorthToMapView(Path2D.Double shape) {
        MapViewPath convertedShape = null;
        if (shape != null) {
            Path2D.Double clipped;
            convertedShape = new MapViewPath(this.mapState);
            convertedShape.appendFromEastNorth(shape);
            convertedShape.setWindingRule(0);
            Rectangle2D extViewBBox = this.mapState.getViewClipRectangle().getInView();
            if (!extViewBBox.contains(convertedShape.getBounds2D()) && (clipped = ShapeClipper.clipShape(convertedShape, extViewBBox)) != null) {
                convertedShape.reset();
                convertedShape.append(clipped, false);
            }
        }
        return convertedShape;
    }

    public void drawArea(IWay<?> w, Color color, MapImage fillImage, Float extent, Float extentThreshold, boolean disabled) {
        MapViewPath pfClip = null;
        if (extent != null) {
            if (!this.usePartialFill(Geometry.getAreaAndPerimeter(w.getNodes()), extent.floatValue(), extentThreshold)) {
                extent = null;
            } else if (!w.isClosed()) {
                pfClip = this.shapeEastNorthToMapView(StyledMapRenderer.getPFClip(w, (double)extent.floatValue() * this.scale));
            }
        }
        this.drawArea(this.getPath(w), color, fillImage, extent, pfClip, disabled);
    }

    private boolean usePartialFill(Geometry.AreaAndPerimeter ap, float extent, Float threshold) {
        if (threshold == null) {
            return true;
        }
        return ap.getPerimeter() * (double)extent * this.scale < (double)threshold.floatValue() * ap.getArea();
    }

    public void drawBoxText(INode n, BoxTextElement bs) {
        if (!this.isShowNames() || bs == null) {
            return;
        }
        MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
        TextLabel text = bs.text;
        String s = text.labelCompositionStrategy.compose(n);
        if (s == null || s.isEmpty()) {
            return;
        }
        Font defaultFont = this.g.getFont();
        this.g.setFont(text.font);
        FontRenderContext frc = this.g.getFontRenderContext();
        Rectangle2D bounds = text.font.getStringBounds(s, frc);
        double x = p.getInViewX() + (double)bs.xOffset;
        double y = p.getInViewY() + (double)bs.yOffset;
        Rectangle box = bs.getBox();
        if (bs.hAlign == BoxTextElement.HorizontalTextAlignment.RIGHT) {
            x += (double)(box.x + box.width + 2);
        } else {
            int textWidth = (int)bounds.getWidth();
            if (bs.hAlign == BoxTextElement.HorizontalTextAlignment.CENTER) {
                x -= (double)textWidth / 2.0;
            } else if (bs.hAlign == BoxTextElement.HorizontalTextAlignment.LEFT) {
                x -= (double)(-box.x + 4 + textWidth);
            } else {
                throw new AssertionError();
            }
        }
        if (bs.vAlign == BoxTextElement.VerticalTextAlignment.BOTTOM) {
            y += (double)(box.y + box.height);
        } else {
            LineMetrics metrics = text.font.getLineMetrics(s, frc);
            if (bs.vAlign == BoxTextElement.VerticalTextAlignment.ABOVE) {
                y -= (double)(-box.y + (int)metrics.getDescent());
            } else if (bs.vAlign == BoxTextElement.VerticalTextAlignment.TOP) {
                y -= (double)(-box.y - (int)metrics.getAscent());
            } else if (bs.vAlign == BoxTextElement.VerticalTextAlignment.CENTER) {
                y += (double)((int)((metrics.getAscent() - metrics.getDescent()) / 2.0f));
            } else if (bs.vAlign == BoxTextElement.VerticalTextAlignment.BELOW) {
                y += (double)(box.y + box.height + (int)metrics.getAscent() + 2);
            } else {
                throw new AssertionError();
            }
        }
        MapViewState.MapViewPoint viewPoint = this.mapState.getForView(x, y);
        AffineTransform at = new AffineTransform();
        at.setToTranslation(Math.round(viewPoint.getInViewX()), Math.round(viewPoint.getInViewY()));
        if (!RotationAngle.NO_ROTATION.equals(text.rotationAngle)) {
            at.rotate(text.rotationAngle.getRotationAngle(n));
        }
        this.displayText(n, text, s, at);
        this.g.setFont(defaultFont);
    }

    public void drawRepeatImage(IWay<?> way, MapImage pattern, boolean disabled, double offset, double spacing, double phase, float opacity, RepeatImageElement.LineImageAlignment align) {
        int imgWidth = pattern.getWidth();
        double repeat = (double)imgWidth + spacing;
        int imgHeight = pattern.getHeight();
        int dy1 = (int)((align.getAlignmentOffset() - 0.5) * (double)imgHeight);
        int dy2 = dy1 + imgHeight;
        OffsetIterator it = new OffsetIterator(this.mapState, way.getNodes(), offset);
        MapViewPath path = new MapViewPath(this.mapState);
        if (it.hasNext()) {
            path.moveTo(it.next());
        }
        while (it.hasNext()) {
            path.lineTo(it.next());
        }
        double startOffset = StyledMapRenderer.computeStartOffset(phase, repeat);
        Image image = pattern.getImage(disabled);
        path.visitClippedLine(repeat, (inLineOffset, start, end, startIsOldEnd) -> {
            double segmentLength = start.distanceToInView(end);
            if (segmentLength < 0.1) {
                return;
            }
            if (segmentLength > repeat * 500.0) {
                return;
            }
            AffineTransform saveTransform = this.g.getTransform();
            this.g.translate(start.getInViewX(), start.getInViewY());
            double dx = end.getInViewX() - start.getInViewX();
            double dy = end.getInViewY() - start.getInViewY();
            this.g.rotate(Math.atan2(dy, dx));
            for (double imageStart = -((inLineOffset - startOffset + repeat) % repeat); imageStart < segmentLength; imageStart += repeat) {
                int x = (int)imageStart;
                int sx1 = Math.max(0, -x);
                int sx2 = imgWidth - Math.max(0, x + imgWidth - (int)Math.ceil(segmentLength));
                Composite saveComposite = this.g.getComposite();
                this.g.setComposite(AlphaComposite.getInstance(3, opacity));
                this.g.drawImage(image, x + sx1, dy1, x + sx2, dy2, sx1, 0, sx2, imgHeight, null);
                this.g.setComposite(saveComposite);
            }
            this.g.setTransform(saveTransform);
        });
    }

    private static double computeStartOffset(double phase, double repeat) {
        double startOffset = phase % repeat;
        if (startOffset < 0.0) {
            startOffset += repeat;
        }
        return startOffset;
    }

    @Override
    public void drawNode(INode n, Color color, int size, boolean fill) {
        if (size <= 0 && !n.isHighlighted()) {
            return;
        }
        MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
        if (n.isHighlighted()) {
            this.drawPointHighlight(p.getInView(), size);
        }
        if (size > 1 && p.isInView()) {
            int radius = size / 2;
            if (this.isInactiveMode || n.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(p.getInViewX() - (double)radius - 1.0, p.getInViewY() - (double)radius - 1.0, (double)size + 1.0, (double)size + 1.0);
            if (fill) {
                this.g.fill(rect);
            } else {
                this.g.draw(rect);
            }
        }
    }

    public void drawNodeIcon(INode n, MapImage img, boolean disabled, boolean selected, boolean member, double theta) {
        MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
        int w = img.getWidth();
        int h = img.getHeight();
        if (n.isHighlighted()) {
            this.drawPointHighlight(p.getInView(), Math.max(w, h));
        }
        this.drawIcon(p.getInViewX(), p.getInViewY(), img, disabled, selected, member, theta, (g, r) -> {
            Color color = this.getSelectionHintColor(disabled, selected);
            g.setColor(color);
            g.draw((Shape)r);
        });
    }

    public void drawAreaIcon(IPrimitive osm, MapImage img, boolean disabled, boolean selected, boolean member, double theta, PositionForAreaStrategy iconPosition) {
        Rectangle2D.Double iconRect = new Rectangle2D.Double((double)(-img.getWidth()) / 2.0, (double)(-img.getHeight()) / 2.0, img.getWidth(), img.getHeight());
        this.forEachPolygon(osm, path -> {
            MapViewPositionAndRotation placement = iconPosition.findLabelPlacement((MapViewPath)path, iconRect);
            if (placement == null) {
                return;
            }
            MapViewState.MapViewPoint p = placement.getPoint();
            this.drawIcon(p.getInViewX(), p.getInViewY(), img, disabled, selected, member, theta + placement.getRotation(), (g, r) -> {
                if (this.useStrokes) {
                    g.setStroke(new BasicStroke(2.0f));
                }
                Color color = this.getSelectionHintColor(disabled, selected);
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * 0.2));
                g.setColor(color);
                g.draw((Shape)r);
            });
        });
    }

    private void drawIcon(double x, double y, MapImage img, boolean disabled, boolean selected, boolean member, double theta, BiConsumer<Graphics2D, Rectangle2D> selectionDrawer) {
        float alpha = img.getAlphaFloat();
        Graphics2D temporaryGraphics = (Graphics2D)this.g.create();
        if (!Utils.equalsEpsilon(alpha, 1.0)) {
            temporaryGraphics.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        temporaryGraphics.translate(Math.round(x), Math.round(y));
        temporaryGraphics.rotate(theta);
        int drawX = -img.getWidth() / 2 + img.offsetX;
        int drawY = -img.getHeight() / 2 + img.offsetY;
        temporaryGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        temporaryGraphics.drawImage(img.getImage(disabled), drawX, drawY, this.nc);
        if (selected || member) {
            selectionDrawer.accept(temporaryGraphics, new Rectangle2D.Double((double)drawX - 2.0, (double)drawY - 2.0, (double)img.getWidth() + 4.0, (double)img.getHeight() + 4.0));
        }
    }

    private Color getSelectionHintColor(boolean disabled, boolean selected) {
        Color color = disabled ? this.inactiveColor : (selected ? this.selectedColor : this.relationSelectedColor);
        return color;
    }

    public void drawNodeSymbol(INode n, Symbol s, Color fillColor, Color strokeColor) {
        MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
        if (n.isHighlighted()) {
            this.drawPointHighlight(p.getInView(), s.size);
        }
        if (fillColor != null || strokeColor != null) {
            Shape shape = s.buildShapeAround(p.getInViewX(), p.getInViewY());
            if (fillColor != null) {
                this.g.setColor(fillColor);
                this.g.fill(shape);
            }
            if (s.stroke != null) {
                this.g.setStroke(s.stroke);
                this.g.setColor(strokeColor);
                this.g.draw(shape);
                this.g.setStroke(new BasicStroke());
            }
        }
    }

    public void drawOrderNumber(INode n1, INode n2, int orderNumber, Color clr) {
        MapViewState.MapViewPoint p1 = this.mapState.getPointFor(n1);
        MapViewState.MapViewPoint p2 = this.mapState.getPointFor(n2);
        this.drawOrderNumber(p1, p2, orderNumber, clr);
    }

    private void drawPathHighlight(MapViewPath path, BasicStroke line) {
        if (path == null) {
            return;
        }
        this.g.setColor(this.highlightColorTransparent);
        float w = line.getLineWidth() + (float)HIGHLIGHT_LINE_WIDTH.get().intValue();
        if (this.useWiderHighlight) {
            w += (float)WIDER_HIGHLIGHT.get().intValue();
        }
        int step = Math.max(HIGHLIGHT_STEP.get(), 1);
        while (w >= line.getLineWidth()) {
            this.g.setStroke(new BasicStroke(w, line.getEndCap(), line.getLineJoin(), line.getMiterLimit()));
            this.g.draw(path);
            w -= (float)step;
        }
    }

    private void drawPointHighlight(Point2D p, int size) {
        this.g.setColor(this.highlightColorTransparent);
        int s = size + HIGHLIGHT_POINT_RADIUS.get();
        if (this.useWiderHighlight) {
            s += WIDER_HIGHLIGHT.get().intValue();
        }
        int step = Math.max(HIGHLIGHT_STEP.get(), 1);
        while (s >= size) {
            int r = (int)Math.floor((double)s / 2.0);
            this.g.fill(new RoundRectangle2D.Double(p.getX() - (double)r, p.getY() - (double)r, s, s, r, r));
            s -= step;
        }
    }

    public void drawRestriction(IRelation<?> r, MapImage icon, boolean disabled) {
        INode viaNode;
        IWay fromWay = null;
        IWay toWay = null;
        IPrimitive via = null;
        for (IRelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete()) {
                return;
            }
            if (m.isWay()) {
                IWay w = (IWay)m.getMember();
                if (w.getNodesCount() < 2) continue;
                switch (m.getRole()) {
                    case "from": {
                        if (fromWay != null) break;
                        fromWay = w;
                        break;
                    }
                    case "to": {
                        if (toWay != null) break;
                        toWay = w;
                        break;
                    }
                    case "via": {
                        if (via != null) break;
                        via = w;
                        break;
                    }
                }
                continue;
            }
            if (!m.isNode()) continue;
            INode n = (INode)m.getMember();
            if (via != null || !"via".equals(m.getRole())) continue;
            via = n;
        }
        if (fromWay == null || toWay == null || via == null) {
            return;
        }
        if (via instanceof INode) {
            viaNode = via;
            if (!fromWay.isFirstLastNode(viaNode)) {
                return;
            }
        } else {
            IWay viaWay = (IWay)via;
            Object firstNode = viaWay.firstNode();
            Object lastNode = viaWay.lastNode();
            Boolean onewayvia = Boolean.FALSE;
            String onewayviastr = viaWay.get("oneway");
            if (onewayviastr != null) {
                if ("-1".equals(onewayviastr)) {
                    onewayvia = Boolean.TRUE;
                    Object tmp = firstNode;
                    firstNode = lastNode;
                    lastNode = tmp;
                } else {
                    onewayvia = Optional.ofNullable(OsmUtils.getOsmBoolean(onewayviastr)).orElse(Boolean.FALSE);
                }
            }
            if (fromWay.isFirstLastNode((INode)firstNode)) {
                viaNode = firstNode;
            } else if (!onewayvia.booleanValue() && fromWay.isFirstLastNode((INode)lastNode)) {
                viaNode = lastNode;
            } else {
                return;
            }
        }
        Object fromNode = fromWay.firstNode() == via ? fromWay.getNode(1) : fromWay.getNode(fromWay.getNodesCount() - 2);
        Point pFrom = this.nc.getPoint((ILatLon)fromNode);
        Point pVia = this.nc.getPoint(viaNode);
        double distanceFromVia = 14.0;
        double dx = pFrom.x >= pVia.x ? (double)(pFrom.x - pVia.x) : (double)(pVia.x - pFrom.x);
        double dy = pFrom.y >= pVia.y ? (double)(pFrom.y - pVia.y) : (double)(pVia.y - pFrom.y);
        double fromAngle = dx == 0.0 ? 1.5707963267948966 : Math.atan(dy / dx);
        double fromAngleDeg = Utils.toDegrees(fromAngle);
        double vx = distanceFromVia * Math.cos(fromAngle);
        double vy = distanceFromVia * Math.sin(fromAngle);
        if (pFrom.x < pVia.x) {
            vx = -vx;
        }
        if (pFrom.y < pVia.y) {
            vy = -vy;
        }
        double distanceFromWay = 10.0;
        double vx2 = 0.0;
        double vy2 = 0.0;
        double iconAngle = 0.0;
        if (pFrom.x >= pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg - 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg + 90.0));
            }
            iconAngle = 270.0 + fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg));
            } else {
                vx2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg + 180.0));
            }
            iconAngle = 90.0 - fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg + 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg - 90.0));
            }
            iconAngle = 90.0 + fromAngleDeg;
        }
        if (pFrom.x >= pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg + 180.0));
            } else {
                vx2 = distanceFromWay * Math.sin(Utils.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Utils.toRadians(fromAngleDeg));
            }
            iconAngle = 270.0 - fromAngleDeg;
        }
        this.drawIcon((double)pVia.x + vx + vx2, (double)pVia.y + vy + vy2, icon, disabled, false, false, Math.toRadians(iconAngle), (graphics2D, rectangle2D) -> {});
    }

    public void drawText(IPrimitive osm, TextLabel text, PositionForAreaStrategy labelPositionStrategy) {
        if (!this.isShowNames()) {
            return;
        }
        String name = text.getString(osm);
        if (name == null || name.isEmpty()) {
            return;
        }
        FontMetrics fontMetrics = this.g.getFontMetrics(text.font);
        Rectangle2D nb = fontMetrics.getStringBounds(name, this.g);
        Font defaultFont = this.g.getFont();
        this.forEachPolygon(osm, path -> {
            PositionForAreaStrategy position = labelPositionStrategy;
            MapViewPositionAndRotation center = position.findLabelPlacement((MapViewPath)path, nb);
            if (center != null) {
                this.displayText(osm, text, name, nb, center);
            } else if (position.supportsGlyphVector()) {
                List<GlyphVector> gvs = Utils.getGlyphVectorsBidi(name, text.font, this.g.getFontRenderContext());
                List<GlyphVector> translatedGvs = position.generateGlyphVectors((MapViewPath)path, nb, gvs, StyledMapRenderer.isGlyphVectorDoubleTranslationBug(text.font));
                this.displayText(() -> translatedGvs.forEach(gv -> this.g.drawGlyphVector((GlyphVector)gv, 0.0f, 0.0f)), () -> translatedGvs.stream().collect(Path2D.Double::new, (p, gv) -> p.append(gv.getOutline(0.0f, 0.0f), false), (p1, p2) -> p1.append((Shape)p2, false)), osm.isDisabled(), text);
            } else {
                Logging.trace("Couldn't find a correct label placement for {0} / {1}", osm, name);
            }
        });
        this.g.setFont(defaultFont);
    }

    private void displayText(IPrimitive osm, TextLabel text, String name, Rectangle2D nb, MapViewPositionAndRotation center) {
        AffineTransform at = new AffineTransform();
        if (Math.abs(center.getRotation()) < 0.01) {
            at.setToTranslation(Math.round(center.getPoint().getInViewX() - nb.getCenterX()), Math.round(center.getPoint().getInViewY() - nb.getCenterY()));
        } else {
            at.setToTranslation(center.getPoint().getInViewX(), center.getPoint().getInViewY());
            at.rotate(center.getRotation());
            at.translate(-nb.getCenterX(), -nb.getCenterY());
        }
        this.displayText(osm, text, name, at);
    }

    private void displayText(IPrimitive osm, TextLabel text, String name, AffineTransform at) {
        this.displayText(() -> {
            AffineTransform defaultTransform = this.g.getTransform();
            this.g.transform(at);
            this.g.setFont(text.font);
            this.g.drawString(name, 0, 0);
            this.g.setTransform(defaultTransform);
        }, () -> {
            FontRenderContext frc = this.g.getFontRenderContext();
            TextLayout tl = new TextLayout(name, text.font, frc);
            return tl.getOutline(at);
        }, osm.isDisabled(), text);
    }

    private void displayText(Runnable fill, Supplier<Shape> outline, boolean disabled, TextLabel text) {
        if (this.isInactiveMode || disabled) {
            this.g.setColor(this.inactiveColor);
            fill.run();
        } else if (text.haloRadius != null) {
            this.g.setStroke(new BasicStroke(2.0f * text.haloRadius.floatValue(), 0, 1));
            this.g.setColor(text.haloColor);
            Shape textOutline = outline.get();
            this.g.draw(textOutline);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(text.color);
            this.g.fill(textOutline);
        } else {
            this.g.setColor(text.color);
            fill.run();
        }
    }

    private void forEachPolygon(IPrimitive osm, Consumer<MapViewPath> consumer) {
        Multipolygon multipolygon;
        if (osm instanceof IWay) {
            consumer.accept(this.getPath((IWay)osm));
        } else if (osm instanceof Relation && !(multipolygon = MultipolygonCache.getInstance().get((Relation)osm)).getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData pd : multipolygon.getCombinedPolygons()) {
                MapViewPath path = new MapViewPath(this.mapState);
                path.appendFromEastNorth(pd.get());
                path.setWindingRule(0);
                consumer.accept(path);
            }
        }
    }

    public void drawWay(IWay<?> way, Color color, BasicStroke line, BasicStroke dashes, Color dashedColor, float offset, boolean showOrientation, boolean showHeadArrowOnly, boolean showOneway, boolean onewayReversed) {
        MapViewPath onewayArrowsCasing;
        MapViewPath onewayArrows;
        List<?> wayNodes;
        MapViewPath path = new MapViewPath(this.mapState);
        MapViewPath orientationArrows = showOrientation ? new MapViewPath(this.mapState) : null;
        Rectangle bounds = this.g.getClipBounds();
        if (bounds != null) {
            bounds.grow(100, 100);
        }
        if ((wayNodes = way.getNodes()).size() < 2) {
            return;
        }
        if (!way.isHighlighted() && this.highlightWaySegments != null) {
            MapViewPath highlightSegs = null;
            for (WaySegment ws : this.highlightWaySegments) {
                if (ws.getWay() != way || (float)ws.getLowerIndex() < offset) continue;
                if (highlightSegs == null) {
                    highlightSegs = new MapViewPath(this.mapState);
                }
                highlightSegs.moveTo((ILatLon)ws.getFirstNode());
                highlightSegs.lineTo((ILatLon)ws.getSecondNode());
            }
            this.drawPathHighlight(highlightSegs, line);
        }
        MapViewState.MapViewPoint lastPoint = null;
        OffsetIterator it = new OffsetIterator(this.mapState, wayNodes, offset);
        boolean initialMoveToNeeded = true;
        ArrowPaintHelper drawArrowHelper = null;
        double minSegmentLenSq = 0.0;
        if (showOrientation) {
            drawArrowHelper = new ArrowPaintHelper(PHI, 10.0f + line.getLineWidth());
            minSegmentLenSq = Math.pow(drawArrowHelper.getOnLineLength() * 1.3, 2.0);
        }
        while (it.hasNext()) {
            MapViewState.MapViewPoint p = (MapViewState.MapViewPoint)it.next();
            if (lastPoint != null) {
                MapViewState.MapViewPoint p1 = lastPoint;
                MapViewState.MapViewPoint p2 = p;
                if (initialMoveToNeeded) {
                    initialMoveToNeeded = false;
                    path.moveTo(p1);
                }
                path.lineTo(p2);
                if (drawArrowHelper != null) {
                    boolean drawArrow;
                    if (way.isSelected()) {
                        drawArrow = !it.hasNext() || p1.distanceToInViewSq(p2) > minSegmentLenSq;
                    } else {
                        boolean bl = drawArrow = (!showHeadArrowOnly || !it.hasNext()) && p1.distanceToInViewSq(p2) > minSegmentLenSq;
                    }
                    if (drawArrow) {
                        drawArrowHelper.paintArrowAt(orientationArrows, p2, p1);
                    }
                }
            }
            lastPoint = p;
        }
        if (showOneway) {
            onewayArrows = new MapViewPath(this.mapState);
            onewayArrowsCasing = new MapViewPath(this.mapState);
            double interval = 60.0;
            path.visitClippedLine(60.0, (inLineOffset, start, end, startIsOldEnd) -> {
                double segmentLength = start.distanceToInView(end);
                if (segmentLength > 0.001) {
                    double nx = (end.getInViewX() - start.getInViewX()) / segmentLength;
                    double ny = (end.getInViewY() - start.getInViewY()) / segmentLength;
                    for (double dist = interval - inLineOffset % interval; dist < segmentLength; dist += interval) {
                        StyledMapRenderer.appendOnewayPath(onewayReversed, start, nx, ny, dist, 3.0, onewayArrowsCasing);
                        StyledMapRenderer.appendOnewayPath(onewayReversed, start, nx, ny, dist, 2.0, onewayArrows);
                    }
                }
            });
        } else {
            onewayArrows = null;
            onewayArrowsCasing = null;
        }
        if (way.isHighlighted()) {
            this.drawPathHighlight(path, line);
        }
        this.displaySegments(path, orientationArrows, onewayArrows, onewayArrowsCasing, color, line, dashes, dashedColor);
    }

    private static void appendOnewayPath(boolean onewayReversed, MapViewState.MapViewPoint p1, double nx, double ny, double dist, double onewaySize, Path2D onewayPath) {
        double fac = (double)(-(onewayReversed ? -1 : 1)) * onewaySize * (1.0 + sinPHI) / (sinPHI * cosPHI);
        double sx = nx * fac;
        double sy = ny * fac;
        double x = p1.getInViewX() + nx * (dist + (double)(onewayReversed ? -1 : 1) * (onewaySize / sinPHI));
        double y = p1.getInViewY() + ny * (dist + (double)(onewayReversed ? -1 : 1) * (onewaySize / sinPHI));
        onewayPath.moveTo(x, y);
        onewayPath.lineTo(x + cosPHI * sx - sinPHI * sy, y + sinPHI * sx + cosPHI * sy);
        onewayPath.lineTo(x + cosPHI * sx + sinPHI * sy, y - sinPHI * sx + cosPHI * sy);
        onewayPath.lineTo(x, y);
    }

    public double getCircum() {
        return this.circum;
    }

    @Override
    public void getColors() {
        super.getColors();
        this.highlightColorTransparent = new Color(this.highlightColor.getRed(), this.highlightColor.getGreen(), this.highlightColor.getBlue(), 100);
        this.backgroundColor = this.styles.getBackgroundColor();
    }

    @Override
    public void getSettings(boolean virtual) {
        Object textAntialiasing;
        super.getSettings(virtual);
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        this.scale = this.nc.getScale();
        this.leftHandTraffic = PREFERENCE_LEFT_HAND_TRAFFIC.get();
        this.useStrokes = (double)this.paintSettings.getUseStrokesDistance() > this.circum;
        this.showNames = (double)this.paintSettings.getShowNamesDistance() > this.circum;
        this.showIcons = (double)this.paintSettings.getShowIconsDistance() > this.circum;
        this.isOutlineOnly = this.paintSettings.isOutlineOnly();
        this.antialiasing = PREFERENCE_ANTIALIASING_USE.get() != false ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        switch (PREFERENCE_TEXT_ANTIALIASING.get()) {
            case "on": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case "off": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                break;
            }
            case "gasp": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                break;
            }
            case "lcd-hrgb": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                break;
            }
            case "lcd-hbgr": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                break;
            }
            case "lcd-vrgb": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
                break;
            }
            case "lcd-vbgr": {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                break;
            }
            default: {
                textAntialiasing = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
        }
        this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntialiasing);
    }

    private MapViewPath getPath(IWay<?> w) {
        MapViewPath path = new MapViewPath(this.mapState);
        if (w.isClosed()) {
            path.appendClosed(w.getNodes(), false);
        } else {
            path.append(w.getNodes(), false);
        }
        return path;
    }

    private static Path2D.Double getPFClip(IWay<?> w, double extent) {
        Path2D.Double clip = new Path2D.Double();
        StyledMapRenderer.buildPFClip(clip, w.getNodes(), extent);
        return clip;
    }

    private static Path2D.Double getPFClip(Multipolygon.PolyData pd, double extent) {
        Path2D.Double clip = new Path2D.Double();
        clip.setWindingRule(0);
        StyledMapRenderer.buildPFClip(clip, pd.getNodes(), extent);
        for (Multipolygon.PolyData pdInner : pd.getInners()) {
            StyledMapRenderer.buildPFClip(clip, pdInner.getNodes(), extent);
        }
        return clip;
    }

    private static void buildPFClip(Path2D.Double clip, List<? extends INode> nodes, double extent) {
        boolean initial = true;
        for (INode iNode : nodes) {
            EastNorth p = iNode.getEastNorth();
            if (p == null) continue;
            if (initial) {
                clip.moveTo(p.getX(), p.getY());
                initial = false;
                continue;
            }
            clip.lineTo(p.getX(), p.getY());
        }
        if (nodes.size() >= 3) {
            EastNorth fst = nodes.get(0).getEastNorth();
            EastNorth eastNorth = nodes.get(1).getEastNorth();
            EastNorth lst = nodes.get(nodes.size() - 1).getEastNorth();
            EastNorth lbo = nodes.get(nodes.size() - 2).getEastNorth();
            EastNorth cLst = StyledMapRenderer.getPFDisplacedEndPoint(lbo, lst, fst, extent);
            EastNorth cFst = StyledMapRenderer.getPFDisplacedEndPoint(eastNorth, fst, cLst != null ? cLst : lst, extent);
            if (cLst == null && cFst != null) {
                cLst = StyledMapRenderer.getPFDisplacedEndPoint(lbo, lst, cFst, extent);
            }
            if (cLst != null) {
                clip.lineTo(cLst.getX(), cLst.getY());
            }
            if (cFst != null) {
                clip.lineTo(cFst.getX(), cFst.getY());
            }
        }
    }

    private static EastNorth getPFDisplacedEndPoint(EastNorth p1, EastNorth p2, EastNorth p3, double extent) {
        double dy2;
        double dx1 = p2.getX() - p1.getX();
        double dy1 = p2.getY() - p1.getY();
        double dx2 = p3.getX() - p2.getX();
        if (dx1 * dx2 + dy1 * (dy2 = p3.getY() - p2.getY()) < 0.0) {
            double len = Math.sqrt(dx1 * dx1 + dy1 * dy1);
            if (len == 0.0) {
                return null;
            }
            double dxm = -dy1 * extent / len;
            double dym = dx1 * extent / len;
            if (dx1 * dy2 - dx2 * dy1 < 0.0) {
                dxm = -dxm;
                dym = -dym;
            }
            return new EastNorth(p2.getX() + dxm, p2.getY() + dym);
        }
        return null;
    }

    private boolean isAreaVisible(Path2D.Double area) {
        Rectangle2D bounds = area.getBounds2D();
        if (bounds.isEmpty()) {
            return false;
        }
        MapViewState.MapViewPoint p = this.mapState.getPointFor(new EastNorth(bounds.getX(), bounds.getY()));
        if (p.getInViewY() < 0.0 || p.getInViewX() > this.mapState.getViewWidth()) {
            return false;
        }
        p = this.mapState.getPointFor(new EastNorth(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight()));
        return p.getInViewX() >= 0.0 && p.getInViewY() <= this.mapState.getViewHeight();
    }

    public boolean isInactiveMode() {
        return this.isInactiveMode;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public boolean isShowNames() {
        return this.showNames && this.doSlowOperations;
    }

    public static int computeFlags(IPrimitive primitive, boolean checkOuterMember) {
        if (primitive.isDisabled()) {
            return 1;
        }
        if (primitive.isSelected()) {
            return 4;
        }
        if (checkOuterMember && primitive.isOuterMemberOfSelected()) {
            return 8;
        }
        if (primitive.isMemberOfSelected()) {
            return 2;
        }
        return 0;
    }

    public void setBenchmarkFactory(Supplier<RenderBenchmarkCollector> benchmarkFactory) {
        this.benchmarkFactory = benchmarkFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(OsmData<?, ?, ?, ?> data, boolean renderVirtualNodes, Bounds bounds) {
        block6: {
            RenderBenchmarkCollector benchmark = this.benchmarkFactory.get();
            BBox bbox = bounds.toBBox();
            this.getSettings(renderVirtualNodes);
            try {
                Lock readLock = data.getReadLock();
                if (readLock.tryLock(1L, TimeUnit.SECONDS)) {
                    try {
                        this.paintWithLock(data, renderVirtualNodes, benchmark, bbox);
                        break block6;
                    }
                    finally {
                        readLock.unlock();
                    }
                }
                Logging.warn("Cannot paint layer {0}: It is locked.");
            }
            catch (InterruptedException e) {
                Logging.warn("Cannot paint layer {0}: Interrupted");
            }
        }
    }

    private void paintWithLock(OsmData<?, ?, ?, ?> data, boolean renderVirtualNodes, RenderBenchmarkCollector benchmark, BBox bbox) {
        try {
            this.highlightWaySegments = data.getHighlightedWaySegments();
            benchmark.renderStart(this.circum);
            List<?> nodes = data.searchNodes(bbox);
            List<?> ways = data.searchWays(bbox);
            List<?> relations = data.searchRelations(bbox);
            ArrayList<StyleRecord> allStyleElems = new ArrayList<StyleRecord>(nodes.size() + ways.size() + relations.size());
            if (THREAD_POOL != null) {
                THREAD_POOL.invoke(new ComputeStyleListWorker(this.circum, this.nc, relations, allStyleElems, Math.max(20, relations.size() / THREAD_POOL.getParallelism() / 3), this.styles));
                THREAD_POOL.invoke(new ComputeStyleListWorker(this.circum, this.nc, new CompositeList(nodes, ways), allStyleElems, Math.max(100, (nodes.size() + ways.size()) / THREAD_POOL.getParallelism() / 3), this.styles));
            } else {
                new ComputeStyleListWorker(this.circum, this.nc, relations, allStyleElems, 0, this.styles).computeDirectly();
                new ComputeStyleListWorker(this.circum, this.nc, new CompositeList(nodes, ways), allStyleElems, 0, this.styles).computeDirectly();
            }
            if (!benchmark.renderSort()) {
                return;
            }
            StyleRecord[] sorted = allStyleElems.toArray(new StyleRecord[0]);
            Arrays.parallelSort(sorted, null);
            if (!benchmark.renderDraw(allStyleElems)) {
                return;
            }
            for (StyleRecord record : sorted) {
                this.paintRecord(record);
            }
            this.drawVirtualNodes(data, bbox);
            benchmark.renderDone();
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("data", data).put("circum", this.circum).put("scale", this.scale).put("paintSettings", this.paintSettings).put("renderVirtualNodes", renderVirtualNodes);
        }
    }

    private void paintRecord(StyleRecord record) {
        try {
            record.paintPrimitive(this.paintSettings, this);
        }
        catch (RuntimeException e) {
            throw BugReport.intercept(e).put("record", record);
        }
    }

    public static class StyleRecord
    implements Comparable<StyleRecord> {
        private final StyleElement style;
        private final IPrimitive osm;
        private final int flags;
        private final long order;

        StyleRecord(StyleElement style, IPrimitive osm, int flags) {
            this.style = style;
            this.osm = osm;
            this.flags = flags;
            long order = 0L;
            if ((this.flags & 1) == 0) {
                order |= 1L;
            }
            order <<= 24;
            order |= StyleRecord.floatToFixed(this.style.majorZIndex, 24);
            order <<= 4;
            order |= (long)(this.flags & 0xF);
            order <<= 24;
            order |= StyleRecord.floatToFixed(this.style.zIndex, 24);
            order <<= 1;
            if (DefaultStyles.SIMPLE_NODE_ELEMSTYLE.equals(this.style)) {
                order |= 1L;
            }
            this.order = order;
        }

        protected static long floatToFixed(float number, int totalBits) {
            long value = (long)Float.floatToIntBits(number) & 0xFFFFFFFFL;
            boolean negative = (value & 0x80000000L) != 0L;
            value ^= 0x80000000L;
            if (totalBits < 32) {
                value >>= 32 - totalBits;
            }
            if (negative) {
                value = (1L << totalBits - 1) - value;
            }
            return value;
        }

        @Override
        public int compareTo(StyleRecord other) {
            int d = Long.compare(this.order, other.order);
            if (d != 0) {
                return d;
            }
            long id = this.osm.getUniqueId() - other.osm.getUniqueId();
            if (id > 0L) {
                return 1;
            }
            if (id < 0L) {
                return -1;
            }
            return Float.compare(this.style.objectZIndex, other.style.objectZIndex);
        }

        public int hashCode() {
            return Objects.hash(this.order, this.osm, this.style, this.flags);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StyleRecord other = (StyleRecord)obj;
            return this.flags == other.flags && this.order == other.order && Objects.equals(this.osm, other.osm) && Objects.equals(this.style, other.style);
        }

        public StyleElement getStyle() {
            return this.style;
        }

        public void paintPrimitive(MapPaintSettings paintSettings, StyledMapRenderer painter) {
            this.style.paintPrimitive(this.osm, paintSettings, painter, (this.flags & 4) != 0, (this.flags & 8) != 0, (this.flags & 2) != 0);
        }

        public String toString() {
            return "StyleRecord [style=" + this.style + ", osm=" + this.osm + ", flags=" + this.flags + "]";
        }
    }
}

