/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    private final AutoScaleMode mode;
    protected long lastZoomTime = -1L;
    protected int lastZoomArea = -1;

    public static void zoomToSelection() {
        OsmData<?, ?, ?, ?> dataSet = MainApplication.getLayerManager().getActiveData();
        if (dataSet == null) {
            return;
        }
        Collection<?> sel = dataSet.getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Nothing selected to zoom to.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        AutoScaleAction.zoomTo(sel);
    }

    public static void zoomTo(Collection<? extends IPrimitive> sel) {
        BoundingXYVisitor bboxCalculator = new BoundingXYVisitor();
        bboxCalculator.computeBoundingBox(sel);
        if (bboxCalculator.getBounds() != null) {
            MainApplication.getMap().mapView.zoomTo(bboxCalculator);
        }
    }

    public static void autoScale(AutoScaleMode mode) {
        new AutoScaleAction(mode, false).autoScale();
    }

    private static int getModeShortcut(String mode) {
        int shortcut = -1;
        if (mode.equals("data")) {
            shortcut = 49;
        } else if (mode.equals("layer")) {
            shortcut = 50;
        } else if (mode.equals("selection")) {
            shortcut = 51;
        } else if (mode.equals("conflict")) {
            shortcut = 52;
        } else if (mode.equals("download")) {
            shortcut = 53;
        } else if (mode.equals("problem")) {
            shortcut = 54;
        } else if (mode.equals("previous")) {
            shortcut = 56;
        } else if (mode.equals("next")) {
            shortcut = 57;
        }
        return shortcut;
    }

    private AutoScaleAction(AutoScaleMode mode, boolean marker) {
        super(marker);
        this.mode = mode;
    }

    public AutoScaleAction(AutoScaleMode mode) {
        super(I18n.tr("Zoom to {0}", mode.getLocalizedLabel()), "dialogs/autoscale/" + mode.getEnglishLabel(), I18n.tr("Zoom the view to {0}.", mode.getLocalizedLabel()), Shortcut.registerShortcut("view:zoom" + mode.getEnglishLabel(), I18n.tr("View: {0}", I18n.tr("Zoom to {0}", mode.getLocalizedLabel())), AutoScaleAction.getModeShortcut(mode.getEnglishLabel()), 5003), true, null, false);
        String label = mode.getEnglishLabel();
        String modeHelp = Character.toUpperCase(label.charAt(0)) + label.substring(1);
        this.setHelpId("Action/AutoScale/" + modeHelp);
        this.mode = mode;
        switch (mode) {
            case DATA: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToData"));
                break;
            }
            case LAYER: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToLayer"));
                break;
            }
            case SELECTION: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToSelection"));
                break;
            }
            case CONFLICT: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToConflict"));
                break;
            }
            case PROBLEM: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToProblem"));
                break;
            }
            case DOWNLOAD: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToDownload"));
                break;
            }
            case PREVIOUS: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToPrevious"));
                break;
            }
            case NEXT: {
                this.setHelpId(HelpUtil.ht("/Action/ZoomToNext"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)mode));
            }
        }
        this.installAdapters();
    }

    public void autoScale() {
        if (MainApplication.isDisplayingMapView()) {
            MapView mapView = MainApplication.getMap().mapView;
            switch (this.mode) {
                case PREVIOUS: {
                    mapView.zoomPrevious();
                    break;
                }
                case NEXT: {
                    mapView.zoomNext();
                    break;
                }
                case PROBLEM: {
                    AutoScaleAction.modeProblem(new ValidatorDialog.ValidatorBoundingXYVisitor());
                    break;
                }
                case DATA: {
                    AutoScaleAction.modeData(new BoundingXYVisitor());
                    break;
                }
                case LAYER: {
                    this.modeLayer(new BoundingXYVisitor());
                    break;
                }
                case SELECTION: 
                case CONFLICT: {
                    this.modeSelectionOrConflict(new BoundingXYVisitor());
                    break;
                }
                case DOWNLOAD: {
                    this.modeDownload();
                }
            }
            this.putValue("active", Boolean.TRUE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.autoScale();
    }

    protected Layer getFirstSelectedLayer() {
        if (this.getLayerManager().getActiveLayer() == null) {
            return null;
        }
        try {
            List<Layer> layers = LayerListDialog.getInstance().getModel().getSelectedLayers();
            if (!layers.isEmpty()) {
                return layers.get(0);
            }
        }
        catch (IllegalStateException e) {
            Logging.error(e);
        }
        return null;
    }

    private static void modeProblem(ValidatorDialog.ValidatorBoundingXYVisitor v) {
        TestError error = MainApplication.getMap().validatorDialog.getSelectedError();
        if (error == null) {
            return;
        }
        v.visit(error);
        if (v.getBounds() == null) {
            return;
        }
        MainApplication.getMap().mapView.zoomTo(v);
    }

    private static void modeData(BoundingXYVisitor v) {
        for (Layer l : MainApplication.getLayerManager().getLayers()) {
            l.visitBoundingBox(v);
        }
        MainApplication.getMap().mapView.zoomTo(v);
    }

    private void modeLayer(BoundingXYVisitor v) {
        Layer l = this.getFirstSelectedLayer();
        if (l == null) {
            return;
        }
        l.visitBoundingBox(v);
        MainApplication.getMap().mapView.zoomTo(v);
    }

    private void modeSelectionOrConflict(BoundingXYVisitor v) {
        HashSet<Object> sel = new HashSet<Object>();
        if (AutoScaleMode.SELECTION == this.mode) {
            OsmData<?, ?, ?, ?> dataSet = this.getLayerManager().getActiveData();
            if (dataSet != null) {
                sel.addAll(dataSet.getSelected());
            }
        } else {
            ConflictDialog conflictDialog = MainApplication.getMap().conflictDialog;
            Conflict<? extends OsmPrimitive> conflict = conflictDialog.getSelectedConflict();
            if (conflict != null) {
                sel.add(conflict.getMy());
            } else if (conflictDialog.getConflicts() != null) {
                sel.addAll(conflictDialog.getConflicts().getMyConflictParties());
            }
        }
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), AutoScaleMode.SELECTION == this.mode ? I18n.tr("Nothing selected to zoom to.", new Object[0]) : I18n.tr("No conflicts to zoom to", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        for (IPrimitive iPrimitive : sel) {
            iPrimitive.accept(v);
        }
        if (v.getBounds() == null) {
            return;
        }
        MainApplication.getMap().mapView.zoomTo(v);
    }

    private void modeDownload() {
        if (this.lastZoomTime > 0L && System.currentTimeMillis() - this.lastZoomTime > Config.getPref().getLong("zoom.bounds.reset.time", TimeUnit.SECONDS.toMillis(10L))) {
            this.lastZoomTime = -1L;
        }
        Bounds bbox = null;
        DataSet dataset = this.getLayerManager().getActiveDataSet();
        if (dataset != null) {
            ArrayList<DataSource> dataSources = new ArrayList<DataSource>(dataset.getDataSources());
            int s = dataSources.size();
            if (s > 0) {
                if (this.lastZoomTime == -1L || this.lastZoomArea == -1 || this.lastZoomArea > s) {
                    this.lastZoomArea = s - 1;
                    bbox = ((DataSource)dataSources.get((int)this.lastZoomArea)).bounds;
                } else if (this.lastZoomArea > 0) {
                    --this.lastZoomArea;
                    bbox = ((DataSource)dataSources.get((int)this.lastZoomArea)).bounds;
                } else {
                    this.lastZoomArea = -1;
                    Area sourceArea = this.getLayerManager().getActiveDataSet().getDataSourceArea();
                    if (sourceArea != null) {
                        bbox = new Bounds(sourceArea.getBounds2D());
                    }
                }
                this.lastZoomTime = System.currentTimeMillis();
            } else {
                this.lastZoomTime = -1L;
                this.lastZoomArea = -1;
            }
            if (bbox != null) {
                MainApplication.getMap().mapView.zoomTo(bbox);
            }
        }
    }

    @Override
    protected void updateEnabledState() {
        OsmData<?, ?, ?, ?> ds = this.getLayerManager().getActiveData();
        MapFrame map = MainApplication.getMap();
        switch (this.mode) {
            case SELECTION: {
                this.setEnabled(ds != null && !ds.selectionEmpty());
                break;
            }
            case LAYER: {
                this.setEnabled(this.getFirstSelectedLayer() != null);
                break;
            }
            case CONFLICT: {
                this.setEnabled(map != null && map.conflictDialog.getSelectedConflict() != null);
                break;
            }
            case DOWNLOAD: {
                this.setEnabled(ds != null && !ds.getDataSources().isEmpty());
                break;
            }
            case PROBLEM: {
                this.setEnabled(map != null && map.validatorDialog.getSelectedError() != null);
                break;
            }
            case PREVIOUS: {
                this.setEnabled(MainApplication.isDisplayingMapView() && map.mapView.hasZoomUndoEntries());
                break;
            }
            case NEXT: {
                this.setEnabled(MainApplication.isDisplayingMapView() && map.mapView.hasZoomRedoEntries());
                break;
            }
            default: {
                this.setEnabled(!this.getLayerManager().getLayers().isEmpty());
            }
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (AutoScaleMode.SELECTION == this.mode) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }
    }

    @Override
    protected final void installAdapters() {
        super.installAdapters();
        MapView.addZoomChangeListener(new ZoomChangeAdapter());
        MainApplication.addMapFrameListener(new MapFrameAdapter());
        this.initEnabledState();
    }

    public static enum AutoScaleMode {
        DATA(I18n.marktr("data")),
        LAYER(I18n.marktr("layer")),
        SELECTION(I18n.marktr("selection")),
        CONFLICT(I18n.marktr("conflict")),
        DOWNLOAD(I18n.marktr("download")),
        PROBLEM(I18n.marktr("problem")),
        PREVIOUS(I18n.marktr("previous")),
        NEXT(I18n.marktr("next"));

        private final String label;

        private AutoScaleMode(String label) {
            this.label = label;
        }

        public String getEnglishLabel() {
            return this.label;
        }

        public String getLocalizedLabel() {
            return I18n.tr(this.label, new Object[0]);
        }

        public static AutoScaleMode of(String englishLabel) {
            for (AutoScaleMode v : AutoScaleMode.values()) {
                if (!Objects.equals(v.label, englishLabel)) continue;
                return v;
            }
            throw new IllegalArgumentException(englishLabel);
        }
    }

    private class ZoomChangeAdapter
    implements NavigatableComponent.ZoomChangeListener {
        private ZoomChangeAdapter() {
        }

        @Override
        public void zoomChanged() {
            AutoScaleAction.this.updateEnabledState();
        }
    }

    private class MapFrameAdapter
    implements MapFrameListener {
        private ListSelectionListener conflictSelectionListener;
        private TreeSelectionListener validatorSelectionListener;

        MapFrameAdapter() {
            if (AutoScaleMode.CONFLICT == AutoScaleAction.this.mode) {
                this.conflictSelectionListener = e -> AutoScaleAction.this.updateEnabledState();
            } else if (AutoScaleMode.PROBLEM == AutoScaleAction.this.mode) {
                this.validatorSelectionListener = e -> AutoScaleAction.this.updateEnabledState();
            }
        }

        @Override
        public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
            if (this.conflictSelectionListener != null) {
                if (newFrame != null) {
                    newFrame.conflictDialog.addListSelectionListener(this.conflictSelectionListener);
                } else if (oldFrame != null) {
                    oldFrame.conflictDialog.removeListSelectionListener(this.conflictSelectionListener);
                }
            } else if (this.validatorSelectionListener != null) {
                if (newFrame != null) {
                    newFrame.validatorDialog.addTreeSelectionListener(this.validatorSelectionListener);
                } else if (oldFrame != null) {
                    oldFrame.validatorDialog.removeTreeSelectionListener(this.validatorSelectionListener);
                }
            }
            AutoScaleAction.this.updateEnabledState();
        }
    }
}

