/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class HistoryOsmPrimitive
implements Tagged,
Comparable<HistoryOsmPrimitive>,
PrimitiveId {
    private final long id;
    private final boolean visible;
    private final User user;
    private final long changesetId;
    private Changeset changeset;
    private final Date timestamp;
    private final long version;
    private Map<String, String> tags;

    protected HistoryOsmPrimitive(long id, long version, boolean visible, User user, long changesetId, Date timestamp) {
        this(id, version, visible, user, changesetId, timestamp, true);
    }

    protected HistoryOsmPrimitive(long id, long version, boolean visible, User user, long changesetId, Date timestamp, boolean checkHistoricParams) {
        this.ensurePositiveLong(id, "id");
        this.ensurePositiveLong(version, "version");
        CheckParameterUtil.ensureParameterNotNull(user, "user");
        if (checkHistoricParams) {
            this.ensurePositiveLong(changesetId, "changesetId");
            CheckParameterUtil.ensureParameterNotNull(timestamp, "timestamp");
        }
        this.id = id;
        this.version = version;
        this.visible = visible;
        this.user = user;
        this.changesetId = changesetId;
        this.timestamp = DateUtils.cloneDate(timestamp);
        this.tags = new HashMap<String, String>();
    }

    protected HistoryOsmPrimitive(OsmPrimitive p) {
        this(p.getId(), p.getVersion(), p.isVisible(), p.getUser(), p.getChangesetId(), Date.from(p.getInstant()));
    }

    public static HistoryOsmPrimitive forOsmPrimitive(OsmPrimitive p) {
        if (p instanceof Node) {
            return new HistoryNode((Node)p);
        }
        if (p instanceof Way) {
            return new HistoryWay((Way)p);
        }
        if (p instanceof Relation) {
            return new HistoryRelation((Relation)p);
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.id, this.getType());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public User getUser() {
        return this.user;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Date getTimestamp() {
        return DateUtils.cloneDate(this.timestamp);
    }

    public long getVersion() {
        return this.version;
    }

    protected final void ensurePositiveLong(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", name, value));
        }
    }

    public boolean matches(long id, long version) {
        return this.id == id && this.version == version;
    }

    public boolean matches(long id) {
        return this.id == id;
    }

    @Override
    public final long getUniqueId() {
        return this.getId();
    }

    @Override
    public final boolean isNew() {
        return false;
    }

    @Override
    public int compareTo(HistoryOsmPrimitive o) {
        if (this.id != o.id) {
            throw new ClassCastException(I18n.tr("Cannot compare primitive with ID ''{0}'' to primitive with ID ''{1}''.", o.id, this.id));
        }
        return Long.compare(this.version, o.version);
    }

    @Override
    public final void put(String key, String value) {
        this.tags.put(key, value);
    }

    @Override
    public final String get(String key) {
        return this.tags.get(key);
    }

    @Override
    public final boolean hasKey(String key) {
        return this.tags.containsKey(key);
    }

    @Override
    public final Map<String, String> getKeys() {
        return this.getTags();
    }

    @Override
    public final void setKeys(Map<String, String> keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void removeAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasKeys() {
        return !this.tags.isEmpty();
    }

    @Override
    public final Collection<String> keySet() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    @Override
    public int getNumKeys() {
        return this.tags.size();
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public void setChangeset(Changeset changeset) {
        this.changeset = changeset;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? new HashMap<String, String>() : new HashMap<String, String>(tags);
    }

    public String getName() {
        if (this.get("name") != null) {
            return this.get("name");
        }
        return null;
    }

    public abstract String getDisplayName(HistoryNameFormatter var1);

    public String getLocalName() {
        String key = "name:" + Locale.getDefault();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage() + '_' + Locale.getDefault().getCountry();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage();
        if (this.get(key) != null) {
            return this.get(key);
        }
        return this.getName();
    }

    protected void fillPrimitiveCommonData(PrimitiveData data) {
        data.setUser(this.user);
        try {
            data.setVisible(this.visible);
        }
        catch (IllegalStateException e) {
            Logging.log(Logging.LEVEL_ERROR, "Cannot change visibility for " + data + ':', e);
        }
        data.setInstant(this.timestamp.toInstant());
        data.setKeys(this.tags);
        data.setOsmId(this.id, (int)this.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HistoryOsmPrimitive that = (HistoryOsmPrimitive)obj;
        return this.id == that.id && this.version == that.version;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [version=" + this.version + ", id=" + this.id + ", visible=" + this.visible + ", " + (this.timestamp != null ? "timestamp=" + this.timestamp : "") + ", " + (this.user != null ? "user=" + this.user + ", " : "") + "changesetId=" + this.changesetId + ']';
    }
}

