/*
 * Decompiled with CFR 0.152.
 */
package uam;

import auto.ageLists;
import gui.Interactor;
import gui.InteractorGui;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import onliner.Python;
import shared.DateTimeUtils;
import shared.FileUtils;
import shared.b;
import shared.m;
import shared.sevenzip;
import shared.uncaughtexception;
import uam.UamConfigNew;
import uru.server.Dataserver;

public class PrepareAge {
    /*
     * WARNING - void declaration
     */
    public static void DoAllWork(String basefolder) {
        String statusfile;
        String oldstatustext;
        String[][] copies;
        String dest;
        File abspath2;
        String abspath;
        String tempfolder = basefolder + "/temp/";
        String archivefolder = basefolder + "/files/http/roots/myst.dustbird.net/uru-ages/";
        String urufilesfolder = basefolder + "/UruFiles/";
        String dataserverfolder = basefolder + "/files/wwwuamsharddataserver/http/";
        String sdlfolder = basefolder + "/files/alcugs/sdl/";
        String agefolder = basefolder + "/files/alcugs/age/";
        String statusfolder = basefolder + "/files/http/roots/myst.dustbird.net/status/";
        InteractorGui interactor = new InteractorGui();
        StringBuilder summary = new StringBuilder();
        summary.append("****************** Summary *******************\n");
        boolean doAgeArchives = new File(archivefolder).exists();
        boolean doDataserver = new File(dataserverfolder).exists();
        UamConfigNew.ArchivesInfo info = UamConfigNew.generateStatusFile(archivefolder, interactor);
        MergeFile urufiles = MergeFile.CreateWithRoot(urufilesfolder);
        String[] manualages = new String[]{"offlineki", "Drizzle", "AgeInformation", "officialnocd", "UamKiPlugin"};
        m.msg(new String[0]);
        m.msg("Preparing shard files...");
        boolean noproblems = true;
        for (String archive : info.newFilenames) {
            File archf = new File(archive);
            boolean ignore2 = false;
            for (String manualage : manualages) {
                if (!archf.getName().startsWith(manualage + "--")) continue;
                ignore2 = true;
            }
            String string = PrepareAge.GetVersionFromFilename(archf.getName());
            Date verdate = PrepareAge.GetDateFromVersion(string);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -20);
            if (verdate == null ? !((Interactor)interactor).AskOkCancel("Unable to parse the version's date: " + string + "  Continue?") : verdate.before(cal.getTime()) && !((Interactor)interactor).AskOkCancel("Version's date is very old: " + string + "  Continue?")) {
                return;
            }
            if (ignore2) {
                m.warn("Skipping Ages because it should be done manually: ", archive);
                continue;
            }
            boolean success2 = PrepareAge.DoShardAgeWork(archive, urufiles, tempfolder);
            if (success2) continue;
            noproblems = false;
        }
        if (!noproblems) {
            summary.append("There were python problems.\n");
            boolean docontinue = ((Interactor)interactor).AskOkCancel("There were problems.  Should we continue?");
            if (!docontinue) {
                return;
            }
        }
        boolean donexuslist = false;
        boolean checkageinfo = true;
        boolean agesmissing = false;
        Iterator cyanages = ageLists.AllCyanAges();
        String string = urufiles.GetAbsPath("/AvailableFanLinks.inf");
        String nexusdata = FileUtils.ReadFileAsString(string);
        OfflineKIInfFile inf = new OfflineKIInfFile(nexusdata);
        Set<String> nexusages = inf.GetAllAgeFilenames();
        OfflineKIInfFile inf2 = new OfflineKIInfFile(FileUtils.ReadFileAsString(urufiles.GetAbsPath("/AvailableExtraLinks.inf")));
        Set<String> nexusages2 = inf2.GetAllAgeFilenames();
        HashSet<String> ageinfoages = new HashSet<String>();
        for (String relpath : urufiles.listChildrenRelpaths("/img/UamAgeInfo/")) {
            String filename = new File(urufiles.GetAbsPath(relpath)).getName();
            if (!filename.startsWith("UamAgeInfo--") || !filename.endsWith(".txt")) continue;
            String agename = filename.substring("UamAgeInfo--".length(), filename.length() - ".txt".length());
            ageinfoages.add(agename);
        }
        for (String relpath : urufiles.listChildrenRelpaths("/dat/")) {
            if (!relpath.endsWith(".age")) continue;
            String agename = new File(urufiles.GetAbsPath(relpath)).getName();
            if (cyanages.contains(agename = agename.substring(0, agename.indexOf("."))) || nexusages.contains(agename) || nexusages2.contains(agename) || ageinfoages.contains(agename)) continue;
            agesmissing = true;
            boolean keepgoing = ((Interactor)interactor).AskOkCancel("The Age was not found in the list, you should make a UamAgeInfo file for it. Continue anyway?");
            if (keepgoing) {
                summary.append("You should add the age info file to the archive and try again:  /img/UamAgeInfo/UamAgeInfo--" + agename + ".txt");
                continue;
            }
            return;
        }
        String absMergedPath = urufiles.MergeAllVersions();
        m.status("Beginning to generate dataserver from ", absMergedPath, " to ", dataserverfolder);
        Dataserver.CreateFiles(absMergedPath, dataserverfolder, true);
        m.status("Copying .sdl and .age files...");
        for (String string2 : urufiles.listChildrenRelpaths("/SDL/")) {
            if (!string2.endsWith(".sdl")) continue;
            abspath = urufiles.GetAbsPath(string2);
            abspath2 = new File(abspath);
            dest = sdlfolder + "/" + abspath2.getName();
            FileUtils.CopyFile(abspath, dest, true, true, true);
            FileUtils.CopyModTime(abspath, dest);
        }
        for (String string3 : urufiles.listChildrenRelpaths("/dat/")) {
            if (!string3.endsWith(".age")) continue;
            abspath = urufiles.GetAbsPath(string3);
            abspath2 = new File(abspath);
            dest = agefolder + "/" + abspath2.getName();
            FileUtils.CopyFile(abspath, dest, true, true, true);
            FileUtils.CopyModTime(abspath, dest);
        }
        for (String[] copy : copies = new String[][]{{absMergedPath + "/ReleaseNotes.html", statusfolder + "/ReleaseNotes.html"}}) {
            String from = copy[0];
            String to = copy[1];
            if (!FileUtils.Exists(from)) continue;
            byte[] data = FileUtils.ReadFile(from);
            FileUtils.SaveFileIfChanged(to, data, true, true);
        }
        String string4 = info.config.data.generateXml();
        if (!string4.equals(oldstatustext = FileUtils.ReadFileAsString(statusfile = archivefolder + "/" + "uam.status.xml"))) {
            void var20_36;
            String curmessage = info.config.data.welcome;
            String newmessage = ((Interactor)interactor).AskQuestion("Do you want a new status message? (blank to keep the old one)");
            if (!newmessage.equals("")) {
                info.config.data.comments.add(curmessage);
                info.config.data.welcome = newmessage;
                String string5 = info.config.data.generateXml();
            }
            FileUtils.CopyFile(statusfile, statusfile + DateTimeUtils.GetSortableCurrentDate() + ".xml", false, false);
            FileUtils.WriteFile(statusfile, b.StringToBytes((String)var20_36));
            m.status("Finished creating new status file!");
        }
        summary.append("(All done!)\n");
        m.msg(new String[0]);
        m.msg(summary.toString());
    }

    public static boolean DoShardAgeWork(String archivestr, MergeFile shardfolder, String tempfolder) {
        File archive = new File(archivestr);
        String name = archive.getName();
        m.msg("Processing ", name);
        String extractpath = tempfolder + "/" + name;
        FileUtils.CreateFolder(extractpath);
        boolean success = sevenzip.extract(archivestr, extractpath);
        if (!success) {
            m.throwUncaughtException("error extracting archive.");
        }
        return PrepareAge.PrepareFileForShard(extractpath, "/", shardfolder);
    }

    private static boolean PrepareFileForShard(String basepath, String relfilename, MergeFile shardfolder) {
        File f = new File(basepath + relfilename);
        String name = f.getName();
        if (f.isDirectory()) {
            boolean success = true;
            for (File child : f.listFiles()) {
                boolean success2 = PrepareAge.PrepareFileForShard(basepath, relfilename + "/" + child.getName(), shardfolder);
                if (success2) continue;
                success = false;
            }
            return success;
        }
        if (f.isFile()) {
            if (name.endsWith(".prp") || name.endsWith(".age") || name.endsWith(".fni") || name.endsWith(".sum") || name.endsWith(".ogg") || name.endsWith(".p2f") || name.endsWith(".bik")) {
                shardfolder.CopyFileIntoHighestVersion(f.getAbsolutePath(), relfilename, true, true, true);
                return true;
            }
            if (name.endsWith(".txt") || name.endsWith(".jpg")) {
                shardfolder.CopyFileIntoHighestVersion(f.getAbsolutePath(), relfilename, true, true, true);
                return true;
            }
            if (name.endsWith(".sdl")) {
                shardfolder.CopyFileIntoHighestVersion(f.getAbsolutePath(), relfilename, true, true, true);
                return true;
            }
            if (name.endsWith(".pak")) {
                byte[] patched = Python.PatchPak(f.getAbsolutePath());
                if (patched != null) {
                    shardfolder.WriteFileToHighestVersion(relfilename, patched, true, true);
                } else {
                    shardfolder.CopyFileIntoHighestVersion(f.getAbsolutePath(), relfilename, true, true, true);
                }
                String absPathToPakFile = shardfolder.GetAbsPath(relfilename);
                boolean success2 = Python.CheckForProblems(absPathToPakFile);
                return success2;
            }
            m.err("Unhandled file: ", relfilename);
            return false;
        }
        throw new uncaughtexception("Neither file nor folder?: " + relfilename);
    }

    public static String GetVersionFromFilename(String filename) {
        return filename.substring(filename.indexOf("--") + 2, filename.length() - ".7z".length());
    }

    public static Date GetDateFromVersion(String ver) {
        try {
            int leftbracket = ver.indexOf("(");
            if (leftbracket != -1) {
                ver = ver.substring(0, leftbracket);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMMd");
            Date d = df.parse(ver);
            return d;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static class OfflineKIInfFile {
        ArrayList<Line> Lines = new ArrayList();
        ArrayList<String> RawLines = new ArrayList();

        public OfflineKIInfFile(String data) {
            data = data.replace("\r\n", "\n");
            String[] lines = data.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                this.RawLines.add(line);
                String[] lineparts = line.split(":");
                if (lineparts.length <= 1) continue;
                Line _line = new Line();
                _line.type = lineparts[0];
                String[] infoparts = lineparts[1].split(",");
                _line.filename = infoparts[0];
                _line.propername = infoparts[1];
                _line.linenum = i;
                this.Lines.add(_line);
            }
        }

        public String ToRawString() {
            StringBuilder r = new StringBuilder();
            for (String line : this.RawLines) {
                r.append(line);
                r.append("\n");
            }
            return r.toString();
        }

        public Set<String> GetAllAgeFilenames() {
            HashSet<String> r = new HashSet<String>();
            for (Line line : this.Lines) {
                r.add(line.filename);
            }
            return r;
        }

        public void AddRestorationLinkLineAlphabetically(String AgeFilename, String AgePropername) {
            boolean posfound = false;
            Line newline = new Line();
            newline.type = "restorationlink";
            newline.filename = AgeFilename;
            newline.propername = AgePropername;
            for (int i = 0; i < this.Lines.size(); ++i) {
                Line line = this.Lines.get(i);
                if (!posfound) {
                    if (!line.type.equals("restorationlink")) continue;
                    if (line.propername.toLowerCase().compareTo(AgePropername.toLowerCase()) > 0) {
                        newline.linenum = i;
                        posfound = true;
                    }
                }
                if (!posfound) continue;
                ++line.linenum;
            }
            this.RawLines.add(newline.linenum, newline.toRawLine());
        }

        public static class Line {
            String type;
            String filename;
            String propername;
            int linenum;

            public String toRawLine() {
                return this.type + ":" + this.filename + "," + this.propername;
            }
        }
    }

    public static class MergeFile
    implements DustFile {
        private File root;
        private String rootstr;
        private int maxversion;

        private MergeFile() {
        }

        public static MergeFile CreateWithRoot(String absroot) {
            MergeFile r = new MergeFile();
            r.root = new File(absroot);
            r.rootstr = r.root.getAbsolutePath();
            r.UpdateInfo();
            return r;
        }

        public int GetMaxVersion() {
            return this.maxversion;
        }

        public void UpdateInfo() {
            this.maxversion = -1;
            for (File child : this.root.listFiles()) {
                if (!child.exists() || !child.isDirectory()) continue;
                try {
                    int curver = Integer.parseInt(child.getName());
                    if (curver <= this.maxversion) continue;
                    this.maxversion = curver;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.maxversion == -1) {
                m.throwUncaughtException("Expected numbered subfoler in: " + this.root.getAbsolutePath());
            }
            for (int i = 0; i <= this.maxversion; ++i) {
                String verpath = this.root.getAbsolutePath() + "/" + Integer.toString(i);
                File verfolder = new File(verpath);
                if (!verfolder.exists()) {
                    m.throwUncaughtException("Folder was expected to exist: " + verpath);
                }
                if (verfolder.isDirectory()) continue;
                m.throwUncaughtException("This should be a folder: " + verpath);
            }
        }

        public void WriteFileToHighestVersion(String relpath, byte[] contents, boolean createdirs, boolean throwexception) {
            String fullpath = this.GetPathToVersion(this.maxversion) + "/" + relpath;
            FileUtils.WriteFile(fullpath, contents, createdirs, throwexception);
        }

        private String GetPathToVersion(int version) {
            return this.rootstr + "/" + Integer.toString(version) + "/";
        }

        public void CopyFileIntoHighestVersion(String fromAbsFilename, String relpath, boolean overwrite, boolean createdirs, boolean throwexception) {
            String fullpath = this.GetPathToVersion(this.maxversion) + "/" + relpath;
            File fullpath2 = new File(fullpath);
            FileUtils.CopyFile(fromAbsFilename, fullpath, overwrite, createdirs, throwexception);
            FileUtils.CopyModTime(fromAbsFilename, fullpath);
        }

        public void SetModificationTime(String relpath, long modtime) {
            String abspath = this.GetAbsPath(relpath);
            File abspath2 = new File(abspath);
            abspath2.setLastModified(modtime);
        }

        public String GetAbsPath(String relpath) {
            for (int i = this.maxversion; i >= 0; --i) {
                String testpath = this.GetPathToVersion(i) + "/" + relpath;
                File testpath2 = new File(testpath);
                if (!testpath2.exists()) continue;
                return testpath2.getAbsolutePath();
            }
            return null;
        }

        public LinkedHashSet<String> listChildrenRelpaths(String relpath) {
            LinkedHashSet<String> r = new LinkedHashSet<String>();
            for (int i = this.maxversion; i >= 0; --i) {
                String curverFolder = this.GetPathToVersion(i) + "/" + relpath;
                File curverFolder2 = new File(curverFolder);
                if (!curverFolder2.exists()) continue;
                for (File child : curverFolder2.listFiles()) {
                    r.add(relpath + "/" + child.getName());
                }
            }
            return r;
        }

        public boolean isFile(String relpath) {
            String abspath = this.GetAbsPath(relpath);
            if (abspath == null) {
                return false;
            }
            File abspath2 = new File(abspath);
            return abspath2.isFile();
        }

        public boolean exists(String relpath) {
            String abspath = this.GetAbsPath(relpath);
            return abspath != null;
        }

        public boolean isDirectory(String relpath) {
            String abspath = this.GetAbsPath(relpath);
            if (abspath == null) {
                return false;
            }
            File abspath2 = new File(abspath);
            return abspath2.isDirectory();
        }

        public String MergeAllVersions() {
            this.cleanMerged("/");
            this.merge("/");
            return this.getMergedAbsPath("/");
        }

        private void merge(String relpath) {
            if (this.isDirectory(relpath)) {
                LinkedHashSet<String> children = this.listChildrenRelpaths(relpath);
                for (String childRelpath : children) {
                    this.merge(childRelpath);
                }
            } else if (this.isFile(relpath)) {
                String abspath = this.GetAbsPath(relpath);
                File abspath2 = new File(abspath);
                long filesize = abspath2.length();
                long moddate = abspath2.lastModified();
                String absMergedPath = this.getMergedAbsPath(relpath);
                File absMergedPath2 = new File(absMergedPath);
                if (!absMergedPath2.exists() || absMergedPath2.length() != filesize || absMergedPath2.lastModified() != moddate) {
                    FileUtils.CopyFile(abspath, absMergedPath, true, true, true);
                    FileUtils.CopyModTime(abspath, absMergedPath);
                }
            } else {
                m.throwUncaughtException("unexpected");
            }
        }

        private String getMergedAbsPath(String relpath) {
            return this.rootstr + "/merged/" + relpath;
        }

        private void cleanMerged(String relpath) {
            String abspath;
            String fullpath = this.getMergedAbsPath(relpath);
            File fullpath2 = new File(fullpath);
            if (fullpath2.isDirectory()) {
                for (File child : fullpath2.listFiles()) {
                    this.cleanMerged(relpath + "/" + child.getName());
                }
            } else if (fullpath2.isFile() && (abspath = this.GetAbsPath(relpath)) == null) {
                FileUtils.DeleteFile(fullpath, true);
            }
        }
    }

    public static interface DustFile {
    }
}

