/*
 * Decompiled with CFR 0.152.
 */
package auto;

import auto.AllGames;
import java.io.File;
import java.util.List;
import prpobjects.pakfile;
import pythondec.pycfile;
import shared.FileUtils;
import shared.b;
import shared.m;

public class Python {
    public static void ListPak(String pakfilename, String gamename) {
        AllGames.GameConversionSub game = AllGames.get(gamename);
        pakfile pak = pakfile.create(pakfilename, game);
        for (pakfile.IndexEntry ind : pak.indices) {
            m.msg(ind.objectname.toString());
        }
    }

    public static void RemovePythonOverrides(String pakfolder, String outfolder, String overriddenpakfile, String gamename) {
        AllGames.GameConversionSub game = AllGames.get(gamename);
        pakfile pak = pakfile.create(pakfolder + "/" + overriddenpakfile, game);
        File pakfolder2 = new File(pakfolder);
        for (File child : pakfolder2.listFiles()) {
            if (!child.isFile() || !child.getName().endsWith(".pak") || child.getName().equals(overriddenpakfile)) continue;
            pakfile curpak = pakfile.create(child.getAbsolutePath(), game);
            block1: for (pakfile.IndexEntry ind : curpak.indices) {
                String pyname = ind.objectname.toString();
                for (int i = 0; i < pak.indices.size(); ++i) {
                    String pyname2 = pak.indices.get((int)i).objectname.toString();
                    if (!pyname.equals(pyname2)) continue;
                    m.msg("Removing py file: ", pyname2, " from ", overriddenpakfile, " because it is also present in ", child.getName());
                    pak.remove(i);
                    continue block1;
                }
            }
        }
        String outfilename = outfolder + "/" + overriddenpakfile;
        byte[] pakbs = pak.compileEncrypted(game.g.format);
        FileUtils.WriteFile(outfilename, pakbs, true, true);
    }

    public static void UnpackPak(String infile, String outfolder, String gamename) {
        m.status("Unpacking pak file...");
        pakfile pak = pakfile.create(infile, AllGames.get(gamename));
        pak.extractPakFile(true, outfolder);
        m.status("Done unpacking!");
    }

    public static void DecompilePakOrPyc(String infile, String outfolder, String gamename) {
        if (infile.endsWith(".pak")) {
            Python.DecompilePak(infile, outfolder, gamename);
        } else if (infile.endsWith(".pyc")) {
            Python.DecompilePyc(infile, outfolder);
        } else {
            m.err("Filename must end with .pyc or .pak");
        }
    }

    public static void DecompilePak(String infile, String outfolder, String gamename) {
        m.status("Decompiling pak file...");
        pakfile pak = pakfile.create(infile, AllGames.get(gamename));
        List<pycfile> pycs = pak.extractPakFile(true);
        int curnum = 0;
        int totalnum = pycs.size();
        for (pycfile pyc : pycs) {
            m.msg("Decompiling: ", pyc.filename, " (file ", Integer.toString(++curnum), " of ", Integer.toString(totalnum), ")");
            pyc.decompile();
            String source = pyc.generateSourceCode();
            String outfile = outfolder + "/" + pyc.filename;
            FileUtils.WriteFile(outfile, b.StringToBytes(source), true, true);
        }
        m.status("Done decompiling!");
    }

    public static void DecompilePyc(String infile, String outfolder) {
        m.status("Decompiling pyc file...");
        pycfile pyc = pycfile.createFromFilename(infile);
        pyc.decompile();
        String source = pyc.generateSourceCode();
        String outfile = outfolder + "/" + new File(infile).getName().replace(".pyc", ".py");
        FileUtils.WriteFile(outfile, b.StringToBytes(source), true, true);
        m.status("Done decompiling!");
    }
}

