/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import shared.Format;
import shared.ICompilable;
import shared.m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IBytedeque {
    public Format format;

    public abstract void writeInt(int var1);

    public abstract void writeShort(short var1);

    public abstract IBytedeque Fork();

    public abstract byte[] getAllBytes();

    public abstract void writeBytes(byte[] var1);

    public abstract void writeByte(byte var1);

    public abstract void writeShorts(short[] var1);

    protected abstract Iterator<byte[]> getIterator();

    public OutputStream getChildStreamIfExists() {
        return null;
    }

    public void writeLong(long l) {
        int i0 = (int)l;
        int i1 = (int)(l >>> 32);
        this.writeInt(i0);
        this.writeInt(i1);
    }

    public void writeFloat(float f) {
        int data = Float.floatToIntBits(f);
        this.writeInt(data);
    }

    public void writeFloats(float[] fs) {
        for (int i = 0; i < fs.length; ++i) {
            this.writeFloat(fs[i]);
        }
    }

    public <T extends ICompilable> void writeArray(T[] vector) {
        int length = vector.length;
        for (int i = 0; i < length; ++i) {
            vector[i].compile(this);
        }
    }

    public <T extends ICompilable> void writeVector(Vector<T> vector) {
        int length = vector.size();
        for (int i = 0; i < length; ++i) {
            ((ICompilable)vector.get(i)).compile(this);
        }
    }

    public <T extends ICompilable> void writeArrayList(ArrayList<T> vector) {
        int length = vector.size();
        for (int i = 0; i < length; ++i) {
            ((ICompilable)vector.get(i)).compile(this);
        }
    }

    public void writeInts(int[] ints) {
        for (int i = 0; i < ints.length; ++i) {
            this.writeInt(ints[i]);
        }
    }

    public void writeMultiDimensionInts(int[][] data) {
        for (int i = 0; i < data.length; ++i) {
            this.writeInts(data[i]);
        }
    }

    public void writeAllBytesToFile(String filename) {
        try {
            FileOutputStream writer = new FileOutputStream(filename);
            Iterator<byte[]> iterator = this.getIterator();
            while (iterator.hasNext()) {
                writer.write(iterator.next());
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e2) {
            m.err("Error writing file:", filename + ":" + e2.getMessage());
        }
    }

    public void flush() {
    }

    public void writeIntAsTwoShorts(int n) {
        short s1 = (short)n;
        short s2 = (short)(n >>> 16);
        this.writeShort(s2);
        this.writeShort(s1);
    }
}

