/*
 * Decompiled with CFR 0.152.
 */
package shared;

import shared.IBytestream;
import shared.b;
import shared.m;
import shared.uncaughtexception;

public class ByteArrayBytestream
extends IBytestream {
    public byte[] data;
    int pos;

    private ByteArrayBytestream() {
    }

    public static ByteArrayBytestream createFromByteArray(byte[] data) {
        ByteArrayBytestream result = new ByteArrayBytestream();
        result.data = data;
        result.pos = 0;
        return result;
    }

    public void skip(long n) {
        this.pos = (int)((long)this.pos + n);
        if (this.pos >= this.data.length) {
            m.throwUncaughtException("Skipped past end of array.");
        }
    }

    protected int read() {
        return b.ByteToInt32(this.readByte());
    }

    public byte readByte() {
        byte result = this.data[this.pos];
        ++this.pos;
        return result;
    }

    public byte[] readBytes(int num) {
        byte[] result = new byte[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.readByte();
        }
        return result;
    }

    public int readInt() {
        int result = b.BytesToInt32(this.data, this.pos);
        this.pos += 4;
        return result;
    }

    public short readShort() {
        short result = b.BytesToInt16(this.data, this.pos);
        this.pos += 2;
        return result;
    }

    public int getAbsoluteOffset() {
        return this.pos;
    }

    public int getFilelength() {
        return this.data.length;
    }

    public int getBytesRemaining() {
        return this.getFilelength() - this.getAbsoluteOffset();
    }

    public IBytestream Fork(long offset) {
        ByteArrayBytestream result = new ByteArrayBytestream();
        result.data = this.data;
        result.pos = (int)offset;
        return result;
    }

    public String toString() {
        int readahead = 128;
        IBytestream fork = this.Fork();
        String result = "\n(source=" + this.sourceName + ")\n";
        try {
            result = result + "(pos=0x" + Integer.toHexString(fork.getAbsoluteOffset()) + "=" + Integer.toString(fork.getAbsoluteOffset()) + ")\n";
            result = result + "(bytes remaining=" + Integer.toString(this.getBytesRemaining()) + ")\n";
            result = result + "Data:\n";
            if (fork.getBytesRemaining() < readahead) {
                readahead = fork.getBytesRemaining();
            }
            if (fork.getBytesRemaining() < 0) {
                throw new uncaughtexception("We've somehow read past the end of the file.  Fix this now!");
            }
            if (fork.getBytesRemaining() == 0) {
                result = result + "End of File.\n";
            }
            for (int i = 0; i < readahead; ++i) {
                byte by = fork.readByte();
                String hex = Integer.toHexString(b.ByteToInt32(by));
                if (hex.length() == 0) {
                    hex = "00";
                }
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                result = result + hex;
                if (i % 4 == 3) {
                    result = result + " ";
                }
                if (i % 16 != 15) continue;
                result = result + "\n";
            }
            fork.close();
        }
        catch (Exception e2) {
            result = result + "Error reading ahead in stream.";
        }
        return result;
    }
}

