/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.uruobj;
import shared.Timestamp;
import shared.readexception;
import uru.Bytedeque;
import uru.context;

public class plNetMessage
extends uruobj {
    public static final int kHasTimeSent = 1;
    public static final int kHasGameMsgRecvrs = 2;
    public static final int kEchoBackToSender = 4;
    public static final int kRequestP2P = 8;
    public static final int kAllowTimeOut = 16;
    public static final int kIndirectMember = 32;
    public static final int kPublicIPClient = 64;
    public static final int kHasContext = 128;
    public static final int kAskVaultForGameState = 256;
    public static final int kHasTransactionID = 512;
    public static final int kNewSDLState = 1024;
    public static final int kInitialAgeStateRequest = 2048;
    public static final int kHasPlayerID = 4096;
    public static final int kUseRelevanceRegions = 8192;
    public static final int kHasAcctUuid = 16384;
    public static final int kInterAgeRouting = 32768;
    public static final int kHasVersion = 65536;
    public static final int kIsSystemMessage = 131072;
    public static final int kNeedsReliableSend = 262144;
    public static final int kRouteToAllPlayers = 524288;
    public int flags;
    public byte xProtocolMajorVersion;
    public byte xProtocolMinorVersion;
    public Timestamp xTimeSent;
    public Integer xContext;
    public Integer xTransId;
    public Integer xPlayerId;
    public byte[] xAccountGuid;

    public plNetMessage(context c) throws readexception {
        this.flags = c.readInt();
        if ((this.flags & 0x10000) != 0) {
            this.xProtocolMajorVersion = c.readByte();
            this.xProtocolMinorVersion = c.readByte();
        }
        if ((this.flags & 1) != 0) {
            this.xTimeSent = new Timestamp(c.in);
        }
        if ((this.flags & 0x80) != 0) {
            this.xContext = c.readInt();
        }
        if ((this.flags & 0x200) != 0) {
            this.xTransId = c.readInt();
        }
        if ((this.flags & 0x1000) != 0) {
            this.xPlayerId = c.readInt();
        }
        if ((this.flags & 0x4000) != 0) {
            this.xAccountGuid = c.readBytes(16);
        }
    }

    public void compile(Bytedeque c) {
        c.writeInt(this.flags);
        if ((this.flags & 0x10000) != 0) {
            c.writeByte(this.xProtocolMajorVersion);
            c.writeByte(this.xProtocolMinorVersion);
        }
        if ((this.flags & 1) != 0) {
            this.xTimeSent.compile(c);
        }
        if ((this.flags & 0x80) != 0) {
            c.writeInt(this.xContext);
        }
        if ((this.flags & 0x200) != 0) {
            c.writeInt(this.xTransId);
        }
        if ((this.flags & 0x1000) != 0) {
            c.writeInt(this.xPlayerId);
        }
        if ((this.flags & 0x4000) != 0) {
            c.writeBytes(this.xAccountGuid);
        }
    }

    private plNetMessage() {
    }

    public static plNetMessage createDefault() {
        plNetMessage r = new plNetMessage();
        r.flags = 0;
        return r;
    }

    public static plNetMessage createWithPlayeridx(int playerIdx) {
        plNetMessage r = new plNetMessage();
        r.flags = 4096;
        r.xPlayerId = playerIdx;
        return r;
    }
}

