/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import moulserver.AuthServer;
import moulserver.Client;
import moulserver.Node;
import moulserver.Version;
import shared.CryptHashes;
import shared.EscapeUtils;
import shared.FileUtils;
import shared.GetResource;
import shared.b;
import shared.m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client_SaveMemories
extends Client {
    public static void SaveMemories(String username, String password, String playername, String outputpath) {
        m.state.push();
        ((m.stateclass)m.state.curstate).showNormalMessages = false;
        Client_SaveMemories client2 = new Client_SaveMemories();
        client2.work(username, password, playername, outputpath);
        m.state.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work(String username, String password, String playername, String outfolder) {
        Version ver = Version.currentMoulagain;
        File of = new File(outfolder);
        if (!of.exists()) {
            m.err("You must select an output folder that already exists.");
            return;
        }
        if (!of.isDirectory()) {
            m.err("You must select an Output folder.");
            return;
        }
        Client.AuthConnection authconn = new Client.AuthConnection(ver, ver.authserver);
        try {
            boolean loginsucceeded = authconn.Login(username, password);
            if (!loginsucceeded) {
                m.err("Login did not succeed.  The username or password was probably incorrect.");
                return;
            }
            AuthServer.AcctPlayerInfo playermsg = authconn.GetPlayer(playername);
            if (playermsg == null) {
                m.err("Avatar name was not found.");
                return;
            }
            ArrayList<byte[]> rawnodes = authconn.GetRawNodes(playermsg.playerId);
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (byte[] rawnode : rawnodes) {
                nodes.add((Node)Node.getNode(rawnode));
            }
            StringBuilder xml2 = new StringBuilder();
            xml2.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
            xml2.append("<?xml-stylesheet type='text/xsl' href='memories.xsl'?>");
            xml2.append("<memories>");
            xml2.append("<version>2</version>");
            HashSet dates = new HashSet();
            for (Node n2 : nodes) {
                StringBuilder xml22;
                Node n;
                m.msg(n2.getClass().getName() + " : " + n2.toString());
                if (n2 instanceof Node.ImageNode) {
                    n = (Node.ImageNode)n2;
                    byte[] data = ((Node.ImageNode)n).getImageData();
                    data = b.substr(data, 4, data.length - 4);
                    String sha1 = b.BytesToHexString(CryptHashes.GetHash(data, CryptHashes.Hashtype.sha1));
                    String filename = sha1 + ".jpg";
                    FileUtils.WriteFile(outfolder + "/" + filename, data);
                    StringBuilder xml23 = new StringBuilder();
                    xml23.append("<imagenode>");
                    xml23.append("<source>moulagain</source>");
                    xml23.append("<creationtime>" + Client_SaveMemories.CleanXml(Long.toString(1000L * (long)((Node.ImageNode)n).n.createTime.intValue())) + "</creationtime>");
                    xml23.append("<modtime>" + Client_SaveMemories.CleanXml(Long.toString(1000L * (long)((Node.ImageNode)n).n.modifyTime.intValue())) + "</modtime>");
                    xml23.append("<owner>" + Client_SaveMemories.CleanXml(Client_SaveMemories.getAvatarName(((Node.ImageNode)n).n.creatorIdx, nodes)) + "</owner>");
                    xml23.append("<caption>" + Client_SaveMemories.CleanXml(((Node.ImageNode)n).getTitle()) + "</caption>");
                    xml23.append("<imagesha1>" + sha1 + "</imagesha1>");
                    xml23.append("</imagenode>");
                    Client_SaveMemories.saveFile(outfolder, xml23);
                    continue;
                }
                if (n2 instanceof Node.TextNoteNode) {
                    n = (Node.TextNoteNode)n2;
                    xml22 = new StringBuilder();
                    xml22.append("<textnotenode>");
                    xml22.append("<source>moulagain</source>");
                    xml22.append("<creationtime>" + Client_SaveMemories.CleanXml(Long.toString(1000L * (long)((Node.TextNoteNode)n).n.createTime.intValue())) + "</creationtime>");
                    xml22.append("<modtime>" + Client_SaveMemories.CleanXml(Long.toString(1000L * (long)((Node.TextNoteNode)n).n.modifyTime.intValue())) + "</modtime>");
                    xml22.append("<owner>" + Client_SaveMemories.CleanXml(Client_SaveMemories.getAvatarName(((Node.TextNoteNode)n).n.creatorIdx, nodes)) + "</owner>");
                    xml22.append("<title>" + Client_SaveMemories.CleanXml(((Node.TextNoteNode)n).getTitle()) + "</title>");
                    xml22.append("<text>" + Client_SaveMemories.CleanXml(((Node.TextNoteNode)n).getContents()) + "</text>");
                    xml22.append("</textnotenode>");
                    Client_SaveMemories.saveFile(outfolder, xml22);
                    continue;
                }
                if (!(n2 instanceof Node.MarkerListNode)) continue;
                n = (Node.MarkerListNode)n2;
                xml22 = new StringBuilder();
                xml22.append("<markerlistnode>");
                xml22.append("<source>moulagain</source>");
                xml22.append("<creationtime>" + Client_SaveMemories.CleanXml(Long.toString(1000L * (long)((Node.MarkerListNode)n).n.createTime.intValue())) + "</creationtime>");
                xml22.append("<modtime>" + Client_SaveMemories.CleanXml(Long.toString(1000L * (long)((Node.MarkerListNode)n).n.modifyTime.intValue())) + "</modtime>");
                xml22.append("<owner>" + Client_SaveMemories.CleanXml(Client_SaveMemories.getAvatarName(((Node.MarkerListNode)n).n.creatorIdx, nodes)) + "</owner>");
                xml22.append("<gamename>" + Client_SaveMemories.CleanXml(((Node.MarkerListNode)n).getGamename()) + "</gamename>");
            }
            for (File f : FileUtils.FindAllFiles(outfolder, ".mem.xml", false)) {
                xml2.append(b.BytesToString(FileUtils.ReadFile(f)));
            }
            xml2.append("</memories>");
            FileUtils.WriteFile(outfolder + "/memories.xml", b.StringToBytes(xml2.toString()));
            FileUtils.WriteFile(outfolder + "/memories.xsl", GetResource.getResourceAsBytes("/files/memories.xsl"));
            FileUtils.WriteFile(outfolder + "/jquery.js", GetResource.getResourceAsBytes("/files/jquery-1.3.2.min.js"));
        }
        finally {
            authconn.Disconnect();
        }
        m.status("In the output folder, there will be a file called 'memories.xml'; open it with your web-browser to view the memories.");
        m.status("Finished creating Memories files!");
    }

    public static String getAvatarName(int KInumber, ArrayList<Node> nodes) {
        for (Node n : nodes) {
            Node.PlayerInfoNode n2;
            if (!(n instanceof Node.PlayerInfoNode) || (n2 = (Node.PlayerInfoNode)n).getPlayerId() != KInumber) continue;
            return n2.getPlayerName();
        }
        return null;
    }

    private static void saveFile(String outfolder, StringBuilder xml2) {
        String xmls = xml2.toString();
        byte[] data = b.StringToBytes(xmls);
        String sha1 = b.BytesToHexString(CryptHashes.GetHash(data, CryptHashes.Hashtype.sha1));
        String filename = sha1 + ".mem.xml";
        FileUtils.WriteFile(outfolder + "/" + filename, data);
    }

    private static String CleanXml(String s) {
        if (s == null) {
            return "";
        }
        s = s.replace("\u001b", "");
        s = EscapeUtils.escapeXmlString(s);
        return s;
    }
}

