/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ILexStream;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import lpg.runtime.UnavailableParserInformationException;

public class LexParser {
    private boolean taking_actions = false;
    private int START_STATE;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int START_SYMBOL;
    private int NUM_RULES;
    private ILexStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private IntTuple action = null;
    private int STACK_INCREMENT = 1024;
    private int stateStackTop;
    private int stackLength = 0;
    private int[] stack;
    private int[] locationStack;
    private int[] tempStack;
    private int lastToken;
    private int currentAction;
    private int curtok;
    private int starttok;
    private int current_kind;

    public void reset(ILexStream tokStream) {
        this.tokStream = tokStream;
    }

    public void reset(ILexStream tokStream, ParseTable prs, RuleAction ra) {
        this.tokStream = tokStream;
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        this.START_SYMBOL = prs.getStartSymbol();
        this.NUM_RULES = prs.getNumRules();
    }

    public LexParser() {
    }

    public LexParser(ILexStream tokStream, ParseTable prs, RuleAction ra) {
        this.reset(tokStream, prs, ra);
    }

    private void reallocateStacks() {
        int old_stack_length = this.stack == null ? 0 : this.stackLength;
        this.stackLength += this.STACK_INCREMENT;
        if (old_stack_length == 0) {
            this.stack = new int[this.stackLength];
            this.locationStack = new int[this.stackLength];
            this.tempStack = new int[this.stackLength];
        } else {
            this.stack = new int[this.stackLength];
            System.arraycopy(this.stack, 0, this.stack, 0, old_stack_length);
            this.locationStack = new int[this.stackLength];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_stack_length);
            this.tempStack = new int[this.stackLength];
            System.arraycopy(this.tempStack, 0, this.tempStack, 0, old_stack_length);
        }
    }

    public final int getFirstToken(int i) {
        return this.getToken(i);
    }

    public final int getLastToken(int i) {
        if (this.taking_actions) {
            return i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(i + 1));
        }
        throw new UnavailableParserInformationException();
    }

    public final int getCurrentRule() {
        if (this.taking_actions) {
            return this.currentAction;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getToken(int i) {
        if (this.taking_actions) {
            return this.locationStack[this.stateStackTop + (i - 1)];
        }
        throw new UnavailableParserInformationException();
    }

    public final void setSym1(int i) {
    }

    public final int getSym(int i) {
        return this.getLastToken(i);
    }

    public final int getFirstToken() {
        return this.starttok;
    }

    public final int getLastToken() {
        return this.lastToken;
    }

    public void resetTokenStream(int i) {
        this.tokStream.reset(i > this.tokStream.getStreamLength() ? this.tokStream.getStreamLength() : i);
        this.curtok = this.tokStream.getToken();
        this.current_kind = this.tokStream.getKind(this.curtok);
        if (this.stack == null) {
            this.reallocateStacks();
        }
        if (this.action == null) {
            this.action = new IntTuple(1024);
        }
    }

    public void parseCharacters(int start_offset, int end_offset) {
        this.parseCharacters(null, start_offset, end_offset);
    }

    public void parseCharacters(Monitor monitor, int start_offset, int end_offset) {
        this.resetTokenStream(start_offset);
        while (this.curtok <= end_offset) {
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            this.lexNextToken(end_offset);
        }
    }

    public void parseCharacters() {
        this.parseCharacters(null);
    }

    public void parseCharacters(Monitor monitor) {
        this.taking_actions = true;
        this.resetTokenStream(0);
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        block2: while (!(this.current_kind == this.EOFT_SYMBOL || monitor != null && monitor.isCancelled())) {
            this.stateStackTop = -1;
            this.currentAction = this.START_STATE;
            this.starttok = this.curtok;
            while (true) {
                try {
                    this.stack[++this.stateStackTop] = this.currentAction;
                }
                catch (IndexOutOfBoundsException e2) {
                    this.reallocateStacks();
                    this.stack[this.stateStackTop] = this.currentAction;
                }
                this.locationStack[this.stateStackTop] = this.curtok;
                this.parseNextCharacter(this.curtok, this.current_kind);
                if (this.currentAction == this.ERROR_ACTION && this.current_kind != this.EOFT_SYMBOL) {
                    int save_next_token = this.tokStream.peek();
                    this.tokStream.reset(this.tokStream.getStreamLength() - 1);
                    this.parseNextCharacter(this.curtok, this.EOFT_SYMBOL);
                    this.tokStream.reset(save_next_token);
                }
                if (this.currentAction > this.ERROR_ACTION) {
                    this.lastToken = this.curtok;
                    this.curtok = this.tokStream.getToken();
                    this.current_kind = this.tokStream.getKind(this.curtok);
                    this.currentAction -= this.ERROR_ACTION;
                    do {
                        this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                        this.ra.ruleAction(this.currentAction);
                        int lhs_symbol = this.prs.lhs(this.currentAction);
                        if (lhs_symbol == this.START_SYMBOL) continue block2;
                        this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                    } while (this.currentAction <= this.NUM_RULES);
                    continue;
                }
                if (this.currentAction >= this.ACCEPT_ACTION) break;
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
            }
            if (this.currentAction == this.ACCEPT_ACTION) continue;
            if (this.starttok == this.curtok) {
                if (this.current_kind == this.EOFT_SYMBOL) break;
                this.tokStream.reportLexicalError(this.starttok, this.curtok);
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
                continue;
            }
            this.tokStream.reportLexicalError(this.starttok, this.lastToken);
        }
        this.taking_actions = false;
    }

    private void parseNextCharacter(int token, int kind) {
        int lhs_symbol;
        int start_action = this.stack[this.stateStackTop];
        int pos = this.stateStackTop;
        int tempStackTop = this.stateStackTop - 1;
        this.currentAction = this.tAction(start_action, kind);
        block0: while (this.currentAction <= this.NUM_RULES) {
            while ((lhs_symbol = this.prs.lhs(this.currentAction)) != this.START_SYMBOL) {
                int state = (tempStackTop -= this.prs.rhs(this.currentAction) - 1) > pos ? this.tempStack[tempStackTop] : this.stack[tempStackTop];
                this.currentAction = this.prs.ntAction(state, lhs_symbol);
                if (this.currentAction <= this.NUM_RULES) continue;
                if (tempStackTop + 1 >= this.stack.length) {
                    this.reallocateStacks();
                }
                pos = pos < tempStackTop ? pos : tempStackTop;
                this.tempStack[tempStackTop + 1] = this.currentAction;
                this.currentAction = this.tAction(this.currentAction, kind);
                continue block0;
            }
            break block0;
        }
        if (this.currentAction != this.ERROR_ACTION) {
            this.currentAction = this.tAction(start_action, kind);
            block2: while (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.ra.ruleAction(this.currentAction);
                    lhs_symbol = this.prs.lhs(this.currentAction);
                    if (lhs_symbol == this.START_SYMBOL) {
                        this.currentAction = this.starttok == token ? this.ERROR_ACTION : this.ACCEPT_ACTION;
                        break block2;
                    }
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                } while (this.currentAction <= this.NUM_RULES);
                this.stack[++this.stateStackTop] = this.currentAction;
                this.locationStack[this.stateStackTop] = token;
                this.currentAction = this.tAction(this.currentAction, kind);
            }
        }
    }

    private int lookahead(int act, int token) {
        return (act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(token))) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.getNext(token)) : act;
    }

    private int tAction(int act, int sym) {
        return (act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.peek()) : act;
    }

    public boolean scanNextToken() {
        return this.lexNextToken(this.tokStream.getStreamLength());
    }

    public boolean scanNextToken(int start_offset) {
        this.resetTokenStream(start_offset);
        return this.lexNextToken(this.tokStream.getStreamLength());
    }

    private boolean lexNextToken(int end_offset) {
        this.taking_actions = false;
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        this.starttok = this.curtok;
        this.action.reset();
        while (true) {
            try {
                this.stack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException e2) {
                this.reallocateStacks();
                this.stack[this.stateStackTop] = this.currentAction;
            }
            this.currentAction = this.lexNextCharacter(this.currentAction, this.current_kind);
            if (this.currentAction == this.ERROR_ACTION && this.current_kind != this.EOFT_SYMBOL) {
                int save_next_token = this.tokStream.peek();
                this.tokStream.reset(this.tokStream.getStreamLength() - 1);
                this.currentAction = this.lexNextCharacter(this.stack[this.stateStackTop], this.EOFT_SYMBOL);
                this.tokStream.reset(save_next_token);
            }
            this.action.add(this.currentAction);
            if (this.currentAction > this.ERROR_ACTION) {
                this.curtok = this.tokStream.getToken();
                if (this.curtok > end_offset) {
                    this.curtok = this.tokStream.getStreamLength();
                }
                this.current_kind = this.tokStream.getKind(this.curtok);
                this.currentAction -= this.ERROR_ACTION;
                do {
                    int lhs_symbol;
                    if ((lhs_symbol = this.prs.lhs(this.currentAction)) == this.START_SYMBOL) {
                        this.parseActions();
                        return true;
                    }
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                } while (this.currentAction <= this.NUM_RULES);
                continue;
            }
            if (this.currentAction >= this.ACCEPT_ACTION) break;
            this.curtok = this.tokStream.getToken();
            if (this.curtok > end_offset) {
                this.curtok = this.tokStream.getStreamLength();
            }
            this.current_kind = this.tokStream.getKind(this.curtok);
        }
        if (this.currentAction == this.ACCEPT_ACTION) {
            return true;
        }
        if (this.starttok == this.curtok) {
            if (this.current_kind == this.EOFT_SYMBOL) {
                this.action = null;
                return false;
            }
            this.lastToken = this.curtok;
            this.tokStream.reportLexicalError(this.starttok, this.curtok);
            this.curtok = this.tokStream.getToken();
            if (this.curtok > end_offset) {
                this.curtok = this.tokStream.getStreamLength();
            }
            this.current_kind = this.tokStream.getKind(this.curtok);
        } else {
            this.lastToken = this.tokStream.getPrevious(this.curtok);
            this.tokStream.reportLexicalError(this.starttok, this.lastToken);
        }
        return true;
    }

    private int lexNextCharacter(int act, int kind) {
        int action_save = this.action.size();
        int pos = this.stateStackTop;
        int tempStackTop = this.stateStackTop - 1;
        act = this.tAction(act, kind);
        block0: while (act <= this.NUM_RULES) {
            int lhs_symbol;
            int state;
            this.action.add(act);
            do {
                if ((lhs_symbol = this.prs.lhs(act)) != this.START_SYMBOL) continue;
                if (this.starttok == this.curtok) {
                    act = this.ERROR_ACTION;
                    break block0;
                }
                this.parseActions();
                return this.ACCEPT_ACTION;
            } while ((act = this.prs.ntAction(state = (tempStackTop -= this.prs.rhs(act) - 1) > pos ? this.tempStack[tempStackTop] : this.stack[tempStackTop], lhs_symbol)) <= this.NUM_RULES);
            if (tempStackTop + 1 >= this.stack.length) {
                this.reallocateStacks();
            }
            pos = pos < tempStackTop ? pos : tempStackTop;
            this.tempStack[tempStackTop + 1] = act;
            act = this.tAction(act, kind);
        }
        if (act == this.ERROR_ACTION) {
            this.action.reset(action_save);
        } else {
            this.stateStackTop = tempStackTop + 1;
            for (int i = pos + 1; i <= this.stateStackTop; ++i) {
                this.stack[i] = this.tempStack[i];
            }
        }
        return act;
    }

    private void parseActions() {
        this.taking_actions = true;
        this.curtok = this.starttok;
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        block0: for (int i = 0; i < this.action.size(); ++i) {
            int lhs_symbol;
            this.stack[++this.stateStackTop] = this.currentAction;
            this.locationStack[this.stateStackTop] = this.curtok;
            this.currentAction = this.action.get(i);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.ra.ruleAction(this.currentAction);
                    lhs_symbol = this.prs.lhs(this.currentAction);
                    if (lhs_symbol == this.START_SYMBOL) break block0;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                } while (this.currentAction <= this.NUM_RULES);
                continue;
            }
            this.lastToken = this.curtok;
            this.curtok = this.tokStream.getNext(this.curtok);
            if (this.currentAction <= this.ERROR_ACTION) continue;
            this.current_kind = this.tokStream.getKind(this.curtok);
            this.currentAction -= this.ERROR_ACTION;
            do {
                this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                this.ra.ruleAction(this.currentAction);
                lhs_symbol = this.prs.lhs(this.currentAction);
                if (lhs_symbol == this.START_SYMBOL) break block0;
                this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
            } while (this.currentAction <= this.NUM_RULES);
        }
        this.taking_actions = false;
    }
}

