/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.adapt.gnu.crypto.util;

import java.math.BigInteger;

public class Util {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final String BASE64_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./";
    private static final char[] BASE64_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./".toCharArray();

    private Util() {
    }

    public static String toString(byte[] ba) {
        return Util.toString(ba, 0, ba.length);
    }

    public static final String toString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[offset + i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String toReversedString(byte[] ba) {
        return Util.toReversedString(ba, 0, ba.length);
    }

    public static final String toReversedString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = offset + length - 1;
        int j = 0;
        while (i >= offset) {
            byte k = ba[offset + i--];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] toBytesFromString(String s) {
        int limit = s.length();
        byte[] result = new byte[(limit + 1) / 2];
        int i = 0;
        int j = 0;
        if (limit % 2 == 1) {
            result[j++] = (byte)Util.fromDigit(s.charAt(i++));
        }
        while (i < limit) {
            result[j] = (byte)(Util.fromDigit(s.charAt(i++)) << 4);
            int n = j++;
            result[n] = (byte)(result[n] | (byte)Util.fromDigit(s.charAt(i++)));
        }
        return result;
    }

    public static byte[] toReversedBytesFromString(String s) {
        int limit = s.length();
        byte[] result = new byte[(limit + 1) / 2];
        int i = 0;
        if (limit % 2 == 1) {
            result[i++] = (byte)Util.fromDigit(s.charAt(--limit));
        }
        while (limit > 0) {
            result[i] = (byte)Util.fromDigit(s.charAt(--limit));
            int n = i++;
            result[n] = (byte)(result[n] | (byte)(Util.fromDigit(s.charAt(--limit)) << 4));
        }
        return result;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hexadecimal digit: " + c);
    }

    public static String toString(int n) {
        char[] buf = new char[8];
        for (int i = 7; i >= 0; --i) {
            buf[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(buf);
    }

    public static String toString(int[] ia) {
        int length = ia.length;
        char[] buf = new char[length * 8];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int k = ia[i];
            buf[j++] = HEX_DIGITS[k >>> 28 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 24 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 20 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 16 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 12 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 8 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String toString(long n) {
        char[] b2 = new char[16];
        for (int i = 15; i >= 0; --i) {
            b2[i] = HEX_DIGITS[(int)(n & 0xFL)];
            n >>>= 4;
        }
        return new String(b2);
    }

    public static String toUnicodeString(byte[] ba) {
        return Util.toUnicodeString(ba, 0, ba.length);
    }

    public static final String toUnicodeString(byte[] ba, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        sb.append('\n').append("\"");
        while (i < length) {
            sb.append("\\u");
            byte k = ba[offset + i++];
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            k = ba[offset + i++];
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            if (++j % 8 != 0) continue;
            sb.append("\"+").append('\n').append("\"");
        }
        sb.append("\"").append('\n');
        return sb.toString();
    }

    public static String toUnicodeString(int[] ia) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        sb.append('\n').append("\"");
        while (i < ia.length) {
            int k = ia[i++];
            sb.append("\\u");
            sb.append(HEX_DIGITS[k >>> 28 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 24 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 20 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 16 & 0xF]);
            sb.append("\\u");
            sb.append(HEX_DIGITS[k >>> 12 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 8 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            if (++j % 4 != 0) continue;
            sb.append("\"+").append('\n').append("\"");
        }
        sb.append("\"").append('\n');
        return sb.toString();
    }

    public static byte[] toBytesFromUnicode(String s) {
        int limit = s.length() * 2;
        byte[] result = new byte[limit];
        for (int i = 0; i < limit; ++i) {
            int c = s.charAt(i >>> 1);
            result[i] = (byte)((i & 1) == 0 ? c >>> 8 : c);
        }
        return result;
    }

    public static String dumpString(byte[] data, int offset, int length, String m2) {
        if (data == null) {
            return m2 + "null\n";
        }
        StringBuffer sb = new StringBuffer(length * 3);
        if (length > 32) {
            sb.append(m2).append("Hexadecimal dump of ").append(length).append(" bytes...\n");
        }
        int end = offset + length;
        int l = Integer.toString(length).length();
        if (l < 4) {
            l = 4;
        }
        while (offset < end) {
            int i;
            if (length > 32) {
                String s = "         " + offset;
                sb.append(m2).append(s.substring(s.length() - l)).append(": ");
            }
            for (i = 0; i < 32 && offset + i + 7 < end; i += 8) {
                sb.append(Util.toString(data, offset + i, 8)).append(' ');
            }
            if (i < 32) {
                while (i < 32 && offset + i < end) {
                    sb.append(Util.byteToString(data[offset + i]));
                    ++i;
                }
            }
            sb.append('\n');
            offset += 32;
        }
        return sb.toString();
    }

    public static String dumpString(byte[] data) {
        return data == null ? "null\n" : Util.dumpString(data, 0, data.length, "");
    }

    public static String dumpString(byte[] data, String m2) {
        return data == null ? "null\n" : Util.dumpString(data, 0, data.length, m2);
    }

    public static String dumpString(byte[] data, int offset, int length) {
        return Util.dumpString(data, offset, length, "");
    }

    public static String byteToString(int n) {
        char[] buf = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(buf);
    }

    public static final String toBase64(byte[] buffer) {
        int len = buffer.length;
        int pos = len % 3;
        int b0 = 0;
        byte b1 = 0;
        byte b2 = 0;
        switch (pos) {
            case 1: {
                b2 = buffer[0];
                break;
            }
            case 2: {
                b1 = buffer[0];
                b2 = buffer[1];
            }
        }
        StringBuffer sb = new StringBuffer();
        boolean notleading = false;
        while (true) {
            int c = (b0 & 0xFC) >>> 2;
            if (notleading || c != 0) {
                sb.append(BASE64_CHARSET[c]);
                notleading = true;
            }
            c = (b0 & 3) << 4 | (b1 & 0xF0) >>> 4;
            if (notleading || c != 0) {
                sb.append(BASE64_CHARSET[c]);
                notleading = true;
            }
            c = (b1 & 0xF) << 2 | (b2 & 0xC0) >>> 6;
            if (notleading || c != 0) {
                sb.append(BASE64_CHARSET[c]);
                notleading = true;
            }
            c = b2 & 0x3F;
            if (notleading || c != 0) {
                sb.append(BASE64_CHARSET[c]);
                notleading = true;
            }
            if (pos >= len) break;
            try {
                b0 = buffer[pos++];
                b1 = buffer[pos++];
                b2 = buffer[pos++];
            }
            catch (ArrayIndexOutOfBoundsException x) {
                // empty catch block
                break;
            }
        }
        if (notleading) {
            return sb.toString();
        }
        return "0";
    }

    /*
     * Exception decompiling
     */
    public static final byte[] fromBase64(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final byte[] trim(BigInteger n) {
        int i;
        byte[] in = n.toByteArray();
        if (in.length == 0 || in[0] != 0) {
            return in;
        }
        int len = in.length;
        for (i = 1; in[i] == 0 && i < len; ++i) {
        }
        byte[] result = new byte[len - i];
        System.arraycopy(in, i, result, 0, len - i);
        return result;
    }

    public static final String dump(BigInteger x) {
        return Util.dumpString(Util.trim(x));
    }
}

