/*
 * Decompiled with CFR 0.152.
 */
package auto;

import auto.Game;
import auto.conversion;
import auto.crowthistle;
import auto.hexisle;
import auto.inplace.Inplace;
import auto.inplace.InplaceFile;
import auto.magiquest;
import auto.mod.AutoMod;
import auto.moul;
import auto.mystv;
import auto.pots;
import java.io.File;
import java.util.Vector;
import prpobjects.pakfile;
import prpobjects.prputils;
import shared.Bytes;
import shared.FileUtils;
import shared.Format;
import shared.GetResource;
import shared.m;
import shared.uncaughtexception;
import uam.Uam;

public class AllGames {
    private static GameConversionSub _hexisle;
    private static GameConversionSub _moul;
    private static GameConversionSub _crowthistle;
    private static GameConversionSub _mystv;
    private static GameConversionSub _pots;
    private static GameConversionSub _mqo;

    public static GameConversionSub get(String gamename) {
        return AllGames.get(Game.getFromName(gamename));
    }

    public static GameConversionSub get(Game game) {
        switch (game) {
            case hexisle: {
                return AllGames.getHexisle();
            }
            case moul: {
                return AllGames.getMoul();
            }
            case crowthistle: {
                return AllGames.getCrowthistle();
            }
            case mystv: {
                return AllGames.getMystV();
            }
            case pots: {
                return AllGames.getPots();
            }
            case mqo: {
                return AllGames.getMqo();
            }
        }
        throw new uncaughtexception("unexpected");
    }

    public static GameConversionSub getMqo() {
        if (_mqo == null) {
            _mqo = new GameConversionSub(magiquest.getGameInfo());
        }
        return _mqo;
    }

    public static GameConversionSub getHexisle() {
        if (_hexisle == null) {
            _hexisle = new GameConversionSub(hexisle.getGameInfo());
        }
        return _hexisle;
    }

    public static GameConversionSub getMoul() {
        if (_moul == null) {
            _moul = new GameConversionSub(moul.getGameInfo());
        }
        return _moul;
    }

    public static GameConversionSub getCrowthistle() {
        if (_crowthistle == null) {
            _crowthistle = new GameConversionSub(crowthistle.getGameInfo());
        }
        return _crowthistle;
    }

    public static GameConversionSub getMystV() {
        if (_mystv == null) {
            _mystv = new GameConversionSub(mystv.getGameInfo());
        }
        return _mystv;
    }

    public static GameConversionSub getPots() {
        if (_pots == null) {
            _pots = new GameConversionSub(pots.getGameInfo());
        }
        return _pots;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GameConversionSub {
        public GameInfo g;

        public GameConversionSub(GameInfo game) {
            this.g = game;
        }

        public String GetAgenameFromPrpname(String prpfile2) {
            int lastslash2;
            int lastslash = prpfile2.lastIndexOf("/");
            int ls = Math.max(lastslash, lastslash2 = prpfile2.lastIndexOf("\\"));
            if (ls != -1) {
                prpfile2 = prpfile2.substring(ls + 1);
            }
            int start = prpfile2.indexOf(this.g.prpMarkerForAgename) + this.g.prpMarkerForAgename.length();
            int end = prpfile2.lastIndexOf(".prp");
            String agename = prpfile2.substring(start, end);
            return agename;
        }

        public void CopyMusic(String infolder, String potsfolder) {
            m.status("Checking the folders you gave...");
            if (!this.isFolderX(infolder)) {
                return;
            }
            if (!AllGames.getPots().isFolderX(potsfolder)) {
                return;
            }
            if (!Uam.HasPermissions(potsfolder)) {
                return;
            }
            for (String filename : this.g.MusicFiles) {
                String infile = infolder + "/sfx/" + filename;
                String outfile = potsfolder + "/MyMusic/" + filename;
                FileUtils.CopyFile(infile, outfile, true, true);
            }
            m.status("Done copying ", this.g.GameName, " music!");
        }

        public boolean isFolderX(String folder) {
            File folderfile = new File(folder);
            if (!folderfile.exists()) {
                m.err("The ", this.g.GameName, " folder you selected doesn't exist.");
                return false;
            }
            if (!folderfile.isDirectory()) {
                m.err("The ", this.g.GameName, " folder you selected must be a folder, not a file.");
                return false;
            }
            File exe = new File(folder + "/" + this.g.DetectionFile);
            if (!exe.exists()) {
                m.err("The ", this.g.GameName, " folder you selected doesn't seem to contain ", this.g.GameName, ".  Please select the folder that contains ", this.g.DetectionFile);
                return false;
            }
            return true;
        }

        public void ConvertGame(String infolder, String potsfolder) {
            m.state.push();
            ((m.stateclass)m.state.curstate).showConsoleMessages = true;
            ((m.stateclass)m.state.curstate).showErrorMessages = true;
            ((m.stateclass)m.state.curstate).showNormalMessages = false;
            ((m.stateclass)m.state.curstate).showWarningMessages = false;
            ((m.stateclass)m.state.curstate).showStatusMessages = true;
            m.status("Checking the folders you gave...");
            if (!this.isFolderX(infolder)) {
                return;
            }
            if (!AllGames.getPots().isFolderX(potsfolder)) {
                return;
            }
            if (!Uam.HasPermissions(potsfolder)) {
                return;
            }
            m.status("Starting conversion of ", this.g.GameName, "...");
            this.convert(infolder, potsfolder);
            this.extractembedded(potsfolder);
            this.automod(infolder, potsfolder);
            this.inplacemod(potsfolder);
            m.state.pop();
            m.status("Dont forget to run SoundDecompress.exe in your Pots folder, in order to get the sounds working!  (You can also click the SoundDecompress button on the form if you prefer.) (If SoundDecompress crashes, it means you have to log into Uru, quit, then try again.)");
            m.status("Conversion completed!");
        }

        public void ConvertFiles(String infolder, String outfolder, Vector<String> files) {
            conversion.Info info = new conversion.Info();
            info.infolder = infolder;
            info.outfolder = outfolder;
            info.g = this.g;
            for (String filename : files) {
                conversion.FileInfo fi = new conversion.FileInfo();
                fi.filename = filename;
                fi.guessFiletype();
                fi.guessAgename();
                conversion.convertFile(info, fi);
            }
        }

        public void ExtractPak(String pakfile2, String outfolder) {
            pakfile pak = new pakfile(pakfile2, this.g, true);
            pak.extractPakFile(true, outfolder);
        }

        private void inplacemod(String potsfolder) {
            InplaceFile pots2 = new InplaceFile(potsfolder, "");
            for (String im : this.g.inplacemods) {
                Inplace.InplaceMod(pots2, im);
            }
        }

        private void automod(String infolder, String outfolder) {
            for (String filename : this.g.automods) {
                AutoMod.SimplicityAutoMod(infolder, outfolder, filename);
            }
        }

        private void extractembedded(String potsfolder) {
            for (EmbeddedFileInfo fi : this.g.embeddedfiles) {
                if (GetResource.hasResource(fi.drizzlePath)) {
                    Bytes bytes = GetResource.getResourceAsBytes(fi.drizzlePath);
                    bytes.saveAsFile(potsfolder + fi.uruPath);
                    continue;
                }
                m.throwUncaughtException("Resource not present: " + fi.drizzlePath);
            }
        }

        private void convert(String infolder, String potsfolder) {
            conversion.Info info = new conversion.Info();
            info.infolder = infolder;
            info.outfolder = potsfolder;
            info.g = this.g;
            conversion.convertFiles(info);
        }
    }

    public static class GameInfo {
        String GameName;
        String DetectionFile;
        String[] MusicFiles;
        public Format format;
        public String prpMarkerForAgename;
        public int PythonVersion;
        public Game game;
        conversion.RenameInfo renameinfo = new conversion.RenameInfo();
        Vector<conversion.FileInfo> allfiles = new Vector();
        prputils.Compiler.Decider decider;
        conversion.PostConversionModifier prpmodifier;
        conversion.FniModifier fnimodifier;
        conversion.AgeModifier agemodifier;
        Vector<EmbeddedFileInfo> embeddedfiles = new Vector();
        Vector<String> automods = new Vector();
        Vector<String> inplacemods = new Vector();

        public void addAgeFiles(String agename, String[] filenames) {
            for (String filename : filenames) {
                conversion.FileInfo fi = new conversion.FileInfo();
                fi.agename = agename;
                fi.filename = filename;
                fi.guessFiletype();
                this.allfiles.add(fi);
            }
        }

        public void addSoundFiles(String[] filenames) {
            for (String filename : filenames) {
                conversion.FileInfo fi = new conversion.FileInfo();
                fi.filename = filename;
                fi.guessFiletype();
                this.allfiles.add(fi);
            }
        }

        public void addAviFiles(String[] filenames) {
            for (String filename : filenames) {
                conversion.FileInfo fi = new conversion.FileInfo();
                fi.filename = filename;
                fi.guessFiletype();
                this.allfiles.add(fi);
            }
        }

        public void addEmbeddedFile(String drizzlePath, String uruPath) {
            EmbeddedFileInfo fi = new EmbeddedFileInfo();
            fi.drizzlePath = drizzlePath;
            fi.uruPath = uruPath;
            this.embeddedfiles.add(fi);
        }

        public void addInplacemods(String ... relpaths) {
            for (String relpath : relpaths) {
                this.inplacemods.add(relpath);
            }
        }

        public void addAutomods(String[] filenames) {
            for (String filename : filenames) {
                this.automods.add(filename);
            }
        }

        public String getNewAgename(conversion.FileInfo file) {
            String newagename = this.renameinfo.agenames.get(file.agename);
            if (newagename == null) {
                newagename = file.agename;
            }
            return newagename;
        }
    }

    public static class EmbeddedFileInfo {
        String drizzlePath;
        String uruPath;
    }
}

