// LAF Base Library
// Copyright (c) 2022 Igara Studio S.A.
// Copyright (c) 2016 David Capello
//
// This file is released under the terms of the MIT license.
// Read LICENSE.txt for more information.

#ifndef BASE_HEX_H_INCLUDED
#define BASE_HEX_H_INCLUDED
#pragma once

namespace base {

  inline bool is_hex_digit(const char c) {
    return ((c >= '0' && c <= '9') ||
            (c >= 'A' && c <= 'F') ||
            (c >= 'a' && c <= 'f'));
  }

  inline int hex_to_int(const char c) {
    if (c >= '0' && c <= '9') return c - '0';
    if (c >= 'A' && c <= 'F') return c - 'A' + 10;
    if (c >= 'a' && c <= 'f') return c - 'a' + 10;
    return 0;
  }

} // namespace base

#endif
