/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.PendingIntent;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.fj;
import com.google.android.gms.internal.fm;
import com.google.android.gms.plus.PlusOneButton;
import com.google.android.gms.plus.PlusOneDummyView;

public final class PlusOneButtonWithPopup
extends ViewGroup {
    private View re;
    private int mSize;
    private int rf;
    private View.OnClickListener rk;
    private String hN;
    private String it;

    public PlusOneButtonWithPopup(Context context) {
        this(context, null);
    }

    public PlusOneButtonWithPopup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.rf = PlusOneButton.getAnnotation(context, attrs);
        this.re = new PlusOneDummyView(context, this.mSize);
        this.addView(this.re);
    }

    private void cS() {
        if (this.re != null) {
            this.removeView(this.re);
        }
        this.re = fm.a(this.getContext(), this.mSize, this.rf, this.hN, this.it);
        if (this.rk != null) {
            this.setOnClickListener(this.rk);
        }
        this.addView(this.re);
    }

    public void initialize(String url, String accountName) {
        dm.a(url, (Object)"Url must not be null");
        this.hN = url;
        this.it = accountName;
        this.cS();
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.rk = onClickListener;
        this.re.setOnClickListener(onClickListener);
    }

    public void setAnnotation(int annotation) {
        this.rf = annotation;
        this.cS();
    }

    public void setSize(int size) {
        this.mSize = size;
        this.cS();
    }

    public PendingIntent getResolution() {
        if (this.re != null) {
            try {
                return this.cT().getResolution();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public void cancelClick() {
        if (this.re != null) {
            try {
                this.cT().cancelClick();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void reinitialize() {
        if (this.re != null) {
            try {
                this.cT().reinitialize();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private fj cT() throws RemoteException {
        IBinder iBinder = (IBinder)this.re.getTag();
        fj fj2 = fj.a.ap(iBinder);
        if (fj2 == null) {
            if (Log.isLoggable((String)"PlusOneButtonWithPopup", (int)5)) {
                Log.w((String)"PlusOneButtonWithPopup", (String)"Failed to get PlusOneDelegate");
            }
            throw new RemoteException();
        }
        return fj2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = this.getPaddingLeft() + this.getPaddingRight();
        int n3 = this.getPaddingTop() + this.getPaddingBottom();
        this.re.measure(this.c(widthMeasureSpec, n2), this.c(heightMeasureSpec, n3));
        this.setMeasuredDimension(this.re.getMeasuredWidth() + n2, this.re.getMeasuredHeight() + n3);
    }

    private int c(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        switch (n4) {
            case -2147483648: 
            case 0x40000000: {
                int n5 = View.MeasureSpec.getSize((int)n2) - n3;
                return View.MeasureSpec.makeMeasureSpec((int)n5, (int)n4);
            }
        }
        return n2;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.re.layout(this.getPaddingLeft(), this.getPaddingTop(), right - left - this.getPaddingRight(), bottom - top - this.getPaddingBottom());
    }
}

