/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.de;
import com.google.android.gms.internal.dj;
import com.google.android.gms.internal.gh;
import com.google.android.gms.internal.gi;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class gj
extends de<gh> {
    private final Activity fD;
    private final int us;
    private final String it;
    private final int mTheme;

    public gj(Activity activity, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, int n2, String string2, int n3) {
        super((Context)activity, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.fD = activity;
        this.us = n2;
        this.it = string2;
        this.mTheme = n3;
    }

    @Override
    protected String ag() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    @Override
    protected String ah() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    protected gh au(IBinder iBinder) {
        return gh.a.as(iBinder);
    }

    @Override
    protected void a(dj dj2, de.d d2) throws RemoteException {
        dj2.a(d2, 4030500);
    }

    public void checkForPreAuthorization(int requestCode) {
        Bundle bundle = this.eb();
        a a2 = new a(requestCode);
        try {
            ((gh)this.bd()).a(bundle, a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            a2.a(8, false, null);
        }
    }

    public void changeMaskedWallet(String googleTransactionId, String merchantTransactionId, int requestCode) {
        Bundle bundle = this.eb();
        a a2 = new a(requestCode);
        try {
            ((gh)this.bd()).a(googleTransactionId, merchantTransactionId, bundle, a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            a2.a(8, (MaskedWallet)null, (Bundle)null);
        }
    }

    public void loadMaskedWallet(MaskedWalletRequest request, int requestCode) {
        Bundle bundle = this.eb();
        a a2 = new a(requestCode);
        try {
            ((gh)this.bd()).a(request, bundle, (gi)a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            a2.a(8, (MaskedWallet)null, (Bundle)null);
        }
    }

    public void loadFullWallet(FullWalletRequest request, int requestCode) {
        a a2 = new a(requestCode);
        Bundle bundle = this.eb();
        try {
            ((gh)this.bd()).a(request, bundle, (gi)a2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            a2.a(8, (FullWallet)null, (Bundle)null);
        }
    }

    public void notifyTransactionStatus(NotifyTransactionStatusRequest request) {
        Bundle bundle = this.eb();
        try {
            ((gh)this.bd()).a(request, bundle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private Bundle eb() {
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", this.us);
        bundle.putString("androidPackageName", this.fD.getPackageName());
        if (!TextUtils.isEmpty((CharSequence)this.it)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(this.it, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", this.mTheme);
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.au(iBinder);
    }

    final class a
    extends gi.a {
        private final int ky;

        public a(int n2) {
            this.ky = n2;
        }

        public void a(int n2, MaskedWallet maskedWallet, Bundle bundle) {
            ConnectionResult connectionResult;
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n2, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(gj.this.fD, this.ky);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                Intent intent;
                int n3;
                if (connectionResult.isSuccess()) {
                    n3 = -1;
                    intent = new Intent();
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET", (Parcelable)maskedWallet);
                } else {
                    n3 = n2 == 408 ? 0 : 1;
                    intent = new Intent();
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n2);
                }
                try {
                    gj.this.fD.createPendingResult(this.ky, intent, 0x40000000).send(n3);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        public void a(int n2, FullWallet fullWallet, Bundle bundle) {
            ConnectionResult connectionResult;
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n2, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(gj.this.fD, this.ky);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                Intent intent;
                int n3;
                if (connectionResult.isSuccess()) {
                    n3 = -1;
                    intent = new Intent();
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET", (Parcelable)fullWallet);
                } else {
                    n3 = n2 == 408 ? 0 : 1;
                    intent = new Intent();
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n2);
                }
                try {
                    gj.this.fD.createPendingResult(this.ky, intent, 0x40000000).send(n3);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        public void a(int n2, boolean bl2, Bundle bundle) {
            Intent intent = new Intent();
            intent.putExtra("com.google.android.gm.wallet.EXTRA_IS_USER_PREAUTHORIZED", bl2);
            try {
                gj.this.fD.createPendingResult(this.ky, intent, 0x40000000).send(-1);
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            }
        }
    }
}

